# queen.tcl
#  Copyright (C) 1998 Kazuhisa Iizuka

proc move_queen {c n x y} {
    global w

    set p [expr $w / 6]
    set x0 [expr $x * $w + 2 + $p]
    set y0 [expr $y * $w + 2 + $p]
    set x1 [expr ($x + 1) * $w + 2 - $p]
    set y1 [expr ($y + 1) * $w + 2 - $p]
    $c coords queen$n $x0 $y0 $x1 $y1
}

proc create_canvas {c N} {
    global w

    set Nw1 [expr $w * $N + 1]
    canvas $c -width $Nw1 -height $Nw1
    incr Nw1
    for {set i 0} {$i <= $N} {incr i} {
	set t [expr $w * $i + 2]
	$c create line $t 1 $t $Nw1
	$c create line 1 $t $Nw1 $t
    }
    for {set i 0} {$i < $N} {incr i} {
	$c create oval 0 0 0 0 -fill blue -tag queen$i -outline blue
	move_queen $c $i $i $i
    }
}

proc set_queen {c pos} {
    for {set i 0} {$i < [llength $pos]} {incr i} {
	move_queen $c $i $i [expr [lindex $pos $i] - 1]
    }
}

proc choice_answer {c n} {
    global answer

    set_queen $c [lindex $answer [expr $n - 1]]
}

proc set_answers {ans} {
    global answer N

    set answer $ans

    if {[winfo exists .ans]} {
	destroy .ans
    }

    frame .ans
    pack .ans -side top -fill both

    create_canvas .ans.c $N
    scale .ans.scale -from 1 -to [llength $answer] -showvalue yes \
	    -command "choice_answer .ans.c"
    pack .ans.scale -side right -fill both
    pack .ans.c
}

proc get_size {} {
    global N

    return $N
}

proc calc {} {
    global answer N

    set num [.top.ent get]
    if {[scan $num "%d" NN] != 1 || $NN < 4 || $NN > 8} {
	bell
	.top.ent delete 0 end
	.top.ent insert end $N
	.top.ent selection range 0 end
	return
    }
    set N $NN
    .top.ent selection range 0 end

    klic main solveQueen $N
}

proc quit_operation {} {
    klic main quit
}


set w 30
set N 6

bind . <Alt-F4> { quit_operation }
bind . <Control-c> { quit_operation }

wm title . "N-Queen"

button .exit -text "Exit" -command quit_operation
pack .exit -side top -fill x -pady 3

frame .top

label .top.lab -text "Size :"
entry .top.ent -width 3
.top.ent insert end $N
.top.ent selection range 0 end

bind .top.ent <Return> { calc }
button .top.go -text "Solve" -command { calc }
pack .top.lab .top.ent .top.go -side left -padx 5

pack .top -side top
