# hanoi.tcl
#  Copyright (C) 1996-1998 Jun Nagumo, Kazuhisa Iizuka

button .b -text Quit -state disabled -command {klic main quit}
pack .b -fill x

canvas .c -width 300 -height 200
.c create line 50 100 50 200 -width 2
.c create line 150 100 150 200 -width 2
.c create line 250 100 250 200 -width 2

pack .c

set stick(1) $num
set stick(2) 0
set stick(3) 0

for {set i $num} {$i >= 1} {incr i -1} {
    set diskid($i) [.c create line [expr 50-$i*5] [expr 200-($num-$i)*8-4] \
                                   [expr 50+$i*5] [expr 200-($num-$i)*8-4] \
                                   -fill blue -width 8] 
    set diskpl($i) 1
}

proc diskmove { n from to } {

    global num
    global stick
    global diskid
    global diskpl

    .c move $diskid($n) 0 [expr -(120+($num-$stick($from))*8)]
    update;after 150

    .c move $diskid($n) [expr ($to-$from)*100] 0
    update;after 150

    .c move $diskid($n) 0 [expr (120+($num-$stick($to)-1)*8)]
    update;after 150

    incr stick($to)    1
    incr stick($from) -1
    set diskpl($n) $to

}
