/****************************************************************
       klitcld.c
               klic <-> Tcl/Tk Interface deamon Version1.01a
       Copyright (C) 1996-1999 Jun Nagumo, Kazuhisa Iizuka
****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <tcl.h>
#include <tk.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

#define ever ;;
#define ADDRESS "/tmp/klitclsoc"      /* UNIX Domain Socket Name */
#define COMLENMAX 8192                /* MAX of command line     */

/**** Prototype definition of functions ****/

int comcheck(char []);
void tclinit(void);
void tkinit(void);
void tkmainloop(void);
void mainloop_dam(ClientData,int);
void tcleval(char *com);
int klic_proc(ClientData,Tcl_Interp *,int,char *[]);
void handler(int);
void tclquit(void);  
void evalfile(void);

void do_com(char *);
/**** Definition of global variables ****/

Tcl_Interp *interp;
int sock;
FILE *sockin,*sockout;

/****************************************************************/
int main(int argc,char *argv[])
{

  int s,flen;
  struct sockaddr_un saun;
  extern FILE *sockin,*sockout;
  char comline[COMLENMAX];
  int command;
  extern Tcl_Interp *interp;
  extern int sock;

  if ((s=socket(AF_UNIX,SOCK_STREAM,0))<0)
    {
      perror("klitcld : socket");
      exit(1);
    }

  saun.sun_family = AF_UNIX;
  strcpy(saun.sun_path,ADDRESS);

  unlink(ADDRESS);

  signal(SIGINT,handler);
  signal(SIGHUP,handler);
  signal(SIGKILL,handler);
  signal(SIGQUIT,handler);
 
  if (bind(s,(struct sockaddr *)&saun,sizeof(saun.sun_family)+strlen(saun.sun_path))<0)
    {
      perror("klitcld : bind");
      exit(1);
    }

  if (listen(s,1)<0)
    {
      perror("klitcld : listen");
      exit(1);
    }

  if ((sock = accept(s,(struct sockaddr *)NULL,&flen))<0)
    {
      perror("klitcld : accept");
      exit(1);
    }

  if ((sockin = fdopen(sock,"r"))==NULL)
    {
      perror("klitcld : fdopen");
      exit(1);
    }

  if ((sockout = fdopen(sock,"w"))==NULL)
    {
      perror("klitcld : fdopen");
      exit(1);
    }

  fprintf(sockout,"%d\n",getpid());
  fflush(sockout);

  for(ever)
    {
      memset(comline,0,COMLENMAX);

      fsync(sock);
      if (fgets(comline,COMLENMAX,sockin)==NULL) {
	break;
      }

      command = comcheck(comline);

      switch(command){
        case 1 : tclinit();continue;
        case 2 : tkinit();continue;
        case 3 : tclinit();tkinit();continue;
        case 4 : tkmainloop();continue;
        case 5 : tclquit();
        case 6 : evalfile();continue;
      }

      tcleval(comline);
    }
}


/****************************************************************
 int comcheck(char comline[])

 check command line
 in  : char comline[]       command line from client
 out : int                  command number
****************************************************************/

int comcheck(char comline[])
{
  char *comname[] = { "",
		      "**TclInit**\n",
		      "**TkInit**\n",
		      "**TclTkInit**\n",
		      "**TkMainLoop**\n",
		      "**TclQuit**\n",
		      "**EvalFile**\n" };
  int i;
  int comcode;

  comcode = 0;

  for(i=1;i<=6;i++)
    {
      if (strcmp(comline,comname[i])==0)
	{
	  comcode = i;
	}
    }

  return comcode;
}

/****************************************************************
 void tclinit(void)

 execute tclinit command
****************************************************************/

void tclinit(void)
{
  extern Tcl_Interp *interp;

  interp = Tcl_CreateInterp();

/*  Tcl_EvalFile(interp,"/usr/local/lib/tcl7.4/init.tcl");*/

  if ( Tcl_Init(interp) == TCL_ERROR )
    {
      fprintf(stderr,"klitcl Tcl_Init: %s\n",interp->result);
      exit(1);
    }

  Tcl_CreateCommand(interp,"klic",klic_proc,
		    (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);

  return;
}

/****************************************************************
 void tkinit(void)

 execute tkinit command
****************************************************************/

void tkinit(void)
{
  extern Tcl_Interp *interp;

#if TK_MAJOR_VERSION < 4 || (TK_MAJOR_VERSION == 4 && TK_MINOR_VERSION < 2)
  Tk_Window mainwin;
#else
  char init_command[256] = "wm title . klitcl";
#endif

#if TK_MAJOR_VERSION < 4 || (TK_MAJOR_VERSION == 4 && TK_MINOR_VERSION < 2)
  mainwin = Tk_CreateMainWindow(interp,NULL,"klitcl","Klitcl");

  if ( mainwin == NULL )
    {
      fprintf(stderr,"klitcl Tk_Create...: %s\n",interp->result);
      exit(1);
    }
#endif

/*  Tcl_SetVar(interp,"tk_library","/usr/local/lib/tk4.0",0); */

  if ( Tk_Init(interp) == TCL_ERROR )
    {
      fprintf(stderr,"klitcl Tk_Init: %s\n",interp->result);
      exit(1);
    }

#if !(TK_MAJOR_VERSION < 4 || (TK_MAJOR_VERSION == 4 && TK_MINOR_VERSION < 2))
  Tcl_Eval(interp, init_command);
#endif

  Tcl_SetVar(interp,"tcl_interactive","0",TCL_GLOBAL_ONLY);
  /* puts("TkInit OK");*/
  return;
}

/****************************************************************
 void tkmainloop(void)

 execute tkmainloop command
****************************************************************/

void tkmainloop(void)
{
  extern int sock;

  Tk_CreateFileHandler(sock,TK_READABLE,
		       (Tk_FileProc *)mainloop_dam,(ClientData)NULL);

  Tk_MainLoop();
}

/****************************************************************
 void mainloop_dam(ClientData clientData,int mask)

 get command from klic user program after called tkmainloop.
****************************************************************/

void mainloop_dam(ClientData clientData,int mask)
{
  int command;
  char comline[COMLENMAX];
  extern FILE *sockin;
  extern int sock;

  memset(comline,0,COMLENMAX);

  fsync(sock);
  if (fgets(comline,COMLENMAX,sockin)== NULL) {
    exit(1);
  }

  command = comcheck(comline);

  switch(command){
    case 1 : tclinit();return;
    case 2 : tkinit();return;
    case 3 : tclinit();tkinit();return;
    case 4 : tkmainloop();return;
    case 5 : tclquit();return;
    case 6 : evalfile();return;
  }

  tcleval(comline);
  return;
}

/****************************************************************
 void tcleval(char *com)

 execute TclEval command
****************************************************************/

void tcleval(char *com)
{
  extern FILE *sockout;
  extern Tcl_Interp *interp;
  extern int sock;

  com[strlen(com)-1] = '\0';
  /* printf("EvalLin: [%s]\n",com); */
  Tcl_Eval(interp,com);

  fprintf(sockout,"%s\n",interp->result);
  fflush(sockout);

  /*  strcat(interp->result,"\n"); */

  /* printf("Result : %s\n",interp->result); */
  /* send(sock,interp->result,strlen(interp->result),0); */

  return;
}

/****************************************************************
 void tcl_quit(void)

  execute TclQuit Command
****************************************************************/

void tclquit(void)
{
  extern int sock;
  extern FILE *sockout;
  extern Tcl_Interp *interp;

  fprintf(sockout,"**Wait**\n");
  fflush(sockout);


  if ( shutdown(sock,0) == -1 )
    {
      perror("klitcld : close");
      exit(1);
    }


  exit(0);
}

/****************************************************************
 void evalfile(void)

 execute evalfile command
****************************************************************/

void evalfile(void)
{
  extern FILE *sockin,*sockout;
  extern Tcl_Interp *interp;
  char comline[COMLENMAX];
  int res;

  fsync(sock);
  fgets(comline,COMLENMAX,sockin);  

  comline[strlen(comline)-1] = '\0';

  res = Tcl_EvalFile(interp,comline); 

  fprintf(sockout,"%s\n",interp->result);
  fflush(sockout);

  return;
}

/****************************************************************
 int klic_proc(ClientData clientData,Tcl_Interp *interp,
	       int argc,char *argv[])

 execute klic command ( call klic predicate )
****************************************************************/
int klic_proc(ClientData clientData,Tcl_Interp *interp,
	      int argc,char *argv[])
{
  extern FILE *sockout;
  extern int sock;

  char callline[COMLENMAX];
  int i;

  callline[0] = '\0';

  strcat(callline,"**Call** ");

  for(i=1;i<argc;i++)
    {
      strcat(callline,argv[i]);
      strcat(callline," ");
    }
  fprintf(sockout,"%s\n",callline);
  fflush(sockout);

  /* strcat(callline,"\n");
  send(sock,callline,strlen(callline),0); */

  return TCL_OK;
}

/****************************************************************
 void handler(void)

 Signal Handler
****************************************************************/

void handler(int a)
{
  extern FILE *sockout;

  signal(SIGINT,SIG_DFL);
  signal(SIGHUP,SIG_DFL);
  signal(SIGQUIT,SIG_DFL);
  signal(SIGKILL,SIG_DFL);

  fprintf(sockout,"**Destroy** \n");
  fflush(sockout);

  if( unlink(ADDRESS) < 0 )
    {
      perror("klitcld : unlink");
      exit(1);
    }
  printf("unlink socket.\n");

  exit(1);
}



/**** eof ****/
