// Copyright (C) 1998,1999 Kazuhisa Iizuka

class HanoiData {
  /**
   * פο.
   */
  private int number;

  /**
   * ˤפΥǡ.
   * 줾 ploe[0], pole[1], pole[2] ɽ.
   * ֲ pole[x][0] ˤʤ,
   * Ǥͤϡפ礭ɽ.
   * ΰ֤˱פʤ 0 Ǥ.
   */
  private int pole[][];

  /**
   * ꤹ뤿.
   * ͤ, Ǥ.
   */
  public static final int L_POLE = 0;

  /**
   * ꤹ뤿.
   * ͤ, Ǥ.
   */
  public static final int M_POLE = 1;

  /**
   * ꤹ뤿.
   * ͤ, Ǥ.
   */
  public static final int R_POLE = 2;

  /**
   * ΰ־ˤפΰ.
   * ˤʤˤʤ -1 Ǥ
   */
  private int top_position[];


  /**
   * ꤵ줿֤ĥǡ.
   * @param <code>number</code> פοꤹ.
   * @param <code>data</code> Υǡ.
   *        ˡ getPoleData() ͤƱ,
   *        ĤˤĤƵҤꤹ,
   */
  HanoiData(int number, int data[][]) {
    if (checkData(number, data) == true) {
      // ξ
      this.number = number;
      top_position = new int[3];
      for (int i = 0; i < 3;  i ++) {
	top_position[i] = number - 1;
	for (int j = 0; j < number; j++) {
	  if (data[i][j] == 0) {
	    top_position[i] = j - 1;
	    break;
	  }
	}
      }
      pole = new int[3][number];
      System.arraycopy(data[0], 0, pole[0], 0, number);
      System.arraycopy(data[1], 0, pole[1], 0, number);
      System.arraycopy(data[2], 0, pole[2], 0, number);
    } else {
      this.number = (number > 0) ? number : 1;
      top_position = new int[3];
      pole = new int[3][number];
      setData();
    }
  }

  /**
   * ٤Ƥαפˤǡ.
   * @param פοꤹ.
   */
  HanoiData(int number) {
    if (number <= 0)
      number = 1;

    this.number = number;
    top_position = new int[3];
    pole = new int[3][number];

    setData();
  }

  /**
   * ˱פʤ٤.
   */
  private void setData() {
    for (int i = 0; i < number; i++) {
      pole[0][i] = number - i;
      pole[1][i] = pole[2][i] = 0;
    }
    top_position[0] = number - 1;
    top_position[1] = top_position[2] = -1;
  }

  /**
   * ǡΤɤå.
   */
  private boolean checkData(int num, int data[][]) {
    if (   num <= 0
	|| data.length != 3
	|| data[0].length != num
	|| data[1].length != num
        || data[2].length != num)
      return false;

    boolean[] list = new boolean[num + 1];
    for (int i = 1; i <= num; i++)
      list[i] = false;

    // Фå
    for (int i = 0; i < 3; i++) {
      int p;
      for (p = 0; p < num; p++) {
	int target = data[i][p];

	if (target < 0 || target > num)
	  return false;

	if (target == 0) {
	  // λĤ꤬Ǥ뤫
	  for (p++; p < num; p++) {
	    if (data[i][p] != 0)
	      return false;
	  }
	  break;
	}

	// αפαפ礭ɤ
	if (p != 0) {
	  if (data[i][p-1] <= target)
	    return false;
	}

	// ǤƱ礭αפ뤫ɤ
	if (list[target] == true)
	  return false;
	list[target] = true;
      }
    }

    // ٤Ƥ礭αפ뤫ɤ
    for (int i = 1; i <= num; i++) {
      if (list[i] != true)
	return false;
    }

    // åϣ
    return true;
  }

  /**
   * Υ󥹥󥹤Τıפο֤.
   */
  public int getNumber() {
    return number;
  }

  /**
   * ϥΥ㤬Ƥ뤫å.
   * פĤˤ٤ƤУϣˤǤ.
   * @return äƤ֤.
   *          ⤷äƤʤ -1 ֤.
   */
  public int getCompletePole() {
    if (top_position[0] == number - 1)
      return 0;
    if (top_position[1] == number - 1)
      return 1;
    if (top_position[2] == number - 1)
      return 2;

    return -1;
  }

  /**
   * ־ˤפư.
   * ƱƱΤǤϰưǤʤȤ.
   * @return ưǤ true. Ǥʤ false.
   */
  public boolean move(int from, int to) {
    if (from < 0 || from > 2 || to < 0 || to > 2)
      return false;

    if (top_position[from] == -1)
      return false;

    int size = pole[from][top_position[from]];

    if (top_position[to] >= 0 && pole[to][top_position[to]] <= size)
      return false;

    // java(win95 jdk1.1.5) bug ?
    // expression "(top_position[from])--;" causes error
    pole[from][top_position[from]--] = 0;
    pole[to][++top_position[to]] = size;

    return true;
  }

  /**
   * ˤפΥǡ.
   * פư, ΥǡϹʤΤ.
   * @return ꤵ줿ˤפΥǡ֤.
   *         礭, (Υ饹󥹥󥹤)פοƱǤ.
   *         ΰֲˤפΥǡƬˤ.
   *         Ǥ integer ,פ礭ɽ,
   *         ͤ 1  (Υ饹󥹥󥹤)פοޤǤˤʤ.
   *         פʤ֤Ǥͤϣˤʤ,
   */
  public int[] getPoleData(int n) {
    if (n < 0 || n > 2)
      return null;

    int ret[] = new int[number];
    System.arraycopy(pole[n], 0, ret, 0, ret.length);

    return ret;
  }

  /**
   * ˤפο֤.
   */
  public int getPoleHeight(int n) {
    return top_position[n] + 1;
  }

  /**
   * Υ֥Ȥʸɽ.
   */
  public String toString() {
    String str = getClass().getName() + ":";
    for (int i = 0; i < 3; i++) {
      str += "[";
      for (int p = 0; p <= top_position[i]; p++) {
	if (p != 0)
	  str += ",";
	str += pole[i][p];
      }
      str += "]";
    }
    return str;
  }
}
