// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.event.*;

class HanoiCanvasMouseListener extends MouseEventWrapper {
  HanoiCanvas hc;

  HanoiCanvasMouseListener(HanoiCanvas hc) {
    this.hc = hc;
  }

  protected void pressed(MouseEvent e) {
    if (hc.disks == null || e.getClickCount() == 2)
      return;

    hc.move_disk = hc.disks.getTopDisk(getPoleAt(e.getX()));
    if (hc.move_disk != null)
      hc.redraw(hc.move_disk.rect);
  }

  protected void clicked(MouseEvent e) {
    if (hc.move_disk != null) {
      hc.move_disk = null;
      hc.redraw();
    }
  }

  protected void dragReleased(MouseEvent e, boolean on_component) {
    if (hc.move_disk != null) {
      hc.move_disk = null;
      hc.redraw();
    }
  }

  protected void dragged(MouseEvent e, boolean on_component) {
    if (hc.move_disk != null && on_component) {
      int from = hc.move_disk.pole;
      int to = getPoleAt(e.getX());
      if (from != to)
	hc.moveDisk(from, to);
    }
  }

  private int getPoleAt(int x) {
    if (x < 140)
      return 0;
    else if (x < 260)
      return 1;
    else
      return 2;
  }
}
