// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.*;
import java.awt.event.*;

class HanoiCanvas extends DoubleBufferedCanvas {
  // ٤Ƥαפ˴ؤǡ
  // HanoiData Ϥ
  protected volatile HanoiCanvasDisk disks;

  // ưα
  protected volatile HanoiCanvasDisk.Disk move_disk;

  // ˥᡼Τ줯󤰤
  protected volatile Rectangle animation_rect;

  // åѥ֥
  protected volatile Object lock;

  // ˥᡼󥹥å
  private Animation animation_thread;

  HanoiCanvas() {
    this(null);
  }

  HanoiCanvas(HanoiData hd) {
    super();

    setData(hd);

    setBackground(Color.lightGray);
    setSize(getPrefferedSize());
    setFont(new Font("SansSerif", Font.PLAIN, 9));

    move_disk = null;
    animation_rect = null;
    animation_thread = null;
    lock = new Object();
  }

  public Dimension getPrefferedSize() {
    return getMinimumSize();
  }

  public Dimension getMinimumSize() {
    return new Dimension(400, 250);
  }

  protected void setData(HanoiData hd) {
    if (hd == null || hd.getNumber() > 10)
      disks = null;
    else
      disks = new HanoiCanvasDisk(hd);

    move_disk = null;
    redraw();
  }

  /**
   * αפ֤.
   */
  public int getMaxSizeDiskPole() {
    if (disks == null)
      return -1;

    return disks.getMaxSizeDiskPole();
  }


  /**
   * פư.
   * from ˤ־αפ to ˰ư.
   */
  public void moveDisk(int from, int to) {
    moveDisk(from, to, 0);
  }

  public void moveDisk(int from, int to, int step) {
    if (disks == null)
      return;

    // ưǽɤå
    if (! disks.canMove(from, to))
      return;

    // ưפ
    HanoiCanvasDisk.Disk disk = disks.getTopDisk(from);

    // ưκɸ
    Rectangle before_rect = new Rectangle(disk.rect);

    disks.move(from, to);  // ưϥ˥᡼θ

    // ưκɸ
    Rectangle after_rect = new Rectangle(disk.rect);

    // ưΥ˥᡼󤬤ޤưƤ
    if (animation_thread != null && animation_thread.isAlive()) {
      animation_thread.interrupt();  // 
      try {
	animation_thread.join();  // λԤ
      } catch(InterruptedException ie) {
	// do nothing
      }
    }

    animation_thread = new Animation(before_rect, after_rect, step);
    animation_thread.start();  // ˥᡼¹
  }

  // ˥᡼󥯥饹
  class Animation extends Thread {
    Rectangle before_rect;
    Rectangle after_rect;
    int step;

    Animation(Rectangle bef, Rectangle aft, int step) {
      before_rect = bef;
      after_rect = aft;
      this.step = step;
    }

    public void run() {
      Point bef_p = before_rect.getLocation();
      Point aft_p = after_rect.getLocation();

      animation_rect = new Rectangle(before_rect);

      if (step > 0) {
	try {
	  for (int i = 0; i <= step; i ++) {
	    int x = bef_p.x + (int)(i *((aft_p.x - bef_p.x) / (double)step));
	    int y = bef_p.y + (int)(i *((aft_p.y - bef_p.y) / (double)step));

	    animation_rect.setLocation(x, y);
	    repaint();
	    Thread.sleep(10);
	  }
	} catch(InterruptedException ie) {
	  // ޤ줿顢롼פλ
	  // System.out.println("Animation interrupted : "+ie);
	}
      }

      // directDraw() Ỳ
      synchronized (HanoiCanvas.this.lock) {
	animation_rect = null;
      }

      // ǽưưפԤʤ
      redraw(after_rect);    // ư
      redraw(before_rect);  // ư
    }
  }

  protected void directDraw(Graphics g) {
    // Animation  animation_rect 򤫤뤬ߥ󥰤ˤä
    // ʲξʬ drawRect()  animation_rect ͤѹ
    // ǽ뤿Ʊ
    synchronized (lock) {
      if (animation_rect != null) {
	g.setColor(Color.gray);
	g.drawRect(animation_rect.x, animation_rect.y,
		   animation_rect.width - 1, animation_rect.height - 1);
      }
    }
  }

  protected void draw(Graphics g) {
    // Хå饦
    g.setColor(getBackground());
    Dimension dim = getSize();
    g.fillRect(0, 0, dim.width, dim.height);

    // Ϥ˹Ȥ
    g.setColor(Color.black);
    g.drawRect(0, 0, 399, 249);

    // 
    g.setColor(new Color(128, 64, 0));
    for (int i = 0; i < 3; i++) {
      int x = 30 + 50 + (20 + 100)*i;  // 濴
      g.fillRect(x  - 10, 70, 20 - 1, 180 - 1);
    }

    if (disks != null) {
      // ٤Ƥαפ
      disks.draw(g);

      if (move_disk != null) {
	// ưαפ򲫿ǰϤ
	Rectangle rect = move_disk.rect;
	g.setColor(Color.yellow);
	g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
      }
    }
  }
}
