// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

import java.net.*;
import java.io.*;

public class Hanoi extends Applet {
  private static int default_server_port = 9007;
  private int port_number;  // ФΥݡֹ
  private String host_name;  // ФΥۥ̾

  private volatile HanoiData h_data;
  private volatile HanoiCanvas h_canvas;

  private volatile Button solve;
  private volatile Button shuffle;
  private volatile Choice choice;

  private Animation thread;

  /**
   * ɸॳ󥹥ȥ饯.
   */
  public Hanoi() {
    setBackground(Color.lightGray);

    EventAction action = new EventAction();

    Panel main_panel = new Panel(new BorderLayout(5, 5));
    add(main_panel);

    Panel button_panel = new Panel();

    main_panel.add(button_panel, "North");

    choice = new Choice();
    for (int i = 1; i <= 10; i++) {
      String str = " " + Integer.toString(i);
      str = str.substring(str.length() - 2);
      choice.addItem(str);
    }
    choice.addItemListener(action);
    button_panel.add(choice);

    solve = new Button(" solve ");
    solve.addActionListener(action);
    button_panel.add(solve);

    shuffle = new Button(" shuffle ");
    shuffle.addActionListener(action);
    button_panel.add(shuffle);

    h_canvas = new HanoiCanvas();
    main_panel.add(h_canvas, "Center");

    setData(3);

    EventWrap listener = new EventWrap(h_canvas);
    h_canvas.addMouseListener(listener);
    h_canvas.addMouseMotionListener(listener);

    thread = null;
  }

  public void init() {
    int num = 3;  // default number of disks

    String number_str = getParameter("NUMBER");
    if (number_str != null) {
      try {
	num = Integer.parseInt(number_str);
      } catch (NumberFormatException e) {
	// do nothig (use default number)
      }
    }

    String server_port_string = getParameter("PORT");
    if (server_port_string != null) {
      try {
	port_number = Integer.parseInt(server_port_string);
      } catch (NumberFormatException e) {
	port_number = default_server_port;
      }
    } else {
      port_number = default_server_port;
    }
    host_name = getCodeBase().getHost();

    // appletviewer ȡhost  "" ˤʤäƤޤ褦Ǥ
    if (host_name.length() == 0)
      host_name = "localhost";

    setData(num);
  }

  public static void main(String args[]) {
    Hanoi hanoi = new Hanoi();
    hanoi.setData(4);

    hanoi.port_number = default_server_port;
    hanoi.host_name = "localhost";
    if (args.length == 2) {
      hanoi.host_name = args[0];
      try {
	hanoi.port_number = Integer.parseInt(args[1]);
      } catch (java.lang.NumberFormatException nfe) {
	System.err.print("usage : java Hanoi [<host> <port>]");
	System.exit(1);
      }
    } else if (args.length != 0 && args.length != 2) {
      System.err.println("usage : java Hanoi [<host> <port>]");
      System.exit(1);
    }

    Frame frame = new Frame(hanoi.getClass().getName());
    frame.add(hanoi, "Center");


    Button exit = new Button(" Exit ");
    exit.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	System.exit(0);
      }
    } );
    frame.add(exit, "North");

    frame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
	System.exit(0);
      }
    });

    frame.pack();
    frame.show();
  }

  /**
   * פξꤹ
   * @param number פ
   */
  private void setData(int number) {
    if (number <= 0) {
      number = 1;
    } else  if (number > 10) {
      number = 10;
    }

    h_data = new HanoiData(number);
    h_canvas.setData(h_data);
    choice.select(number - 1);
  }

  /**
   * ʣ˥ȥ꡼.
   */
  private JK makeJK() {
    InputStream in;
    OutputStream out;

    // System.out.println("Connect : " + host_name + ":" + port_number);

    try {
      Socket sock;

      sock = new Socket(host_name, port_number);
      in = sock.getInputStream();
      out = sock.getOutputStream();
    } catch(Exception e) {
      System.err.println("Error in making socket(" + e + ")");
      System.out.println("  Connecting : " + host_name + ":" + port_number);

      return null;
    }

    // JKȥ꡼κ
    return new JK(in, out);
  }

  private Data encodeData() {
    Data data[] = new Data[3];

    for (int i = 0; i < 3; i++) {
      data[i] = convertPole(h_data.getPoleData(i), h_data.getPoleHeight(i));
    }

    return Data.List(data);
  }

  private static Data convertPole(int pole[], int size) {
    Data data[] = new Data[size];

    for (int i = 0; i < size; i++) {
      data[i] = Data.Integer(pole[i]);
    }

    return Data.List(data);
  }

  /**
   * ϥΥβ
   */
  private void solveHanoi() {
    int to = (h_canvas.getMaxSizeDiskPole() + 1) % 3;

    Data disk_data = encodeData();    // פΥǡ
    Data to_data = Data.Integer(to);  // ưֹ

    JK jks = makeJK();
    if (jks == null) {
      Toolkit tk = getToolkit();
      if (tk != null)
	tk.beep();

      return;
    }

    Data args[] = new Data[] {disk_data, to_data};
    Data ret = jks.call("hanoi", "hanoi", args);

    jks.close();

    thread = new Animation(ret);
    thread.start();
  }

  private void threadStop() {
    if (thread != null && thread.isAlive()) {
      thread.interrupt();  // 
      try {
	thread.join(1000);  // ôֽλԤ
      } catch(InterruptedException ie) {
	// do nothing
      }

      if (thread.isAlive()) {
	thread.stop();  // Ū˽λ
      }
    }
  }

  class EventAction implements ActionListener, ItemListener {
    public void actionPerformed(ActionEvent e) {
      synchronized(h_canvas) {
	threadStop();

	if (h_data == null) {
	  Toolkit tk = getToolkit();
	  if (tk != null)
	    tk.beep();
	  return;
	}

	if (e.getSource() == solve) {
	  solveHanoi();
	} else if (e.getSource() == shuffle) {
	  int pole[][] = new int[3][];
	  int height[] = new int[3];
	  int num = h_data.getNumber();
	  for (int i = 0; i < 3; i++) {
	    pole[i] = new int[num];
	    height[i] = 0;
	  }
	  for (int i = num; i >= 1; i--) {
	    double dd = Math.random();
	    int p = (int)(3.0 * dd);
	    if (p > 2)
	      p = 2;
	    pole[p][height[p]++] = i;
	  }
	  h_data = new HanoiData(num, pole);
	  h_canvas.setData(h_data);
	}
      }
    }

    public void itemStateChanged(ItemEvent e) {
      synchronized(h_canvas) {
	threadStop();
	setData(choice.getSelectedIndex() + 1);
      }
    }
  }

  class Animation extends Thread {
    Data answer[];

    Animation(Data answer) {
      this.answer =  Data.ListToArray(answer);
    }

    public void run() {
      for (int i = 0; i < answer.length; i++) {
	try {
	  if (i != 0)
	    Thread.sleep(500);
	} catch(InterruptedException ie) {
	  // ߤä齪λ
	  return;
	}

	Data args[] = answer[i].getFunctorArguments();
	int from = args[0].getInteger();
	int to = args[1].getInteger();
	h_canvas.moveDisk(from, to, 20);
      }
    }
  }

  class EventWrap extends HanoiCanvasMouseListener {
    EventWrap(HanoiCanvas hc) {
      super(hc);
    }

    public void mousePressed(MouseEvent e) {
      synchronized(h_canvas) {
	threadStop();
	super.mousePressed(e);
      }
    }
  }
}
