// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.*;
import java.util.*;

class Node extends Data {
  Node parent;
  Rectangle rect;
  String label;

  Node(Data data, Rectangle rect, String label) {
    super(data);

    this.parent = null;
    this.rect = rect;
    this.label = label;
  }

  boolean isRootNode() {
    return parent == null;
  }

  boolean contains(int x, int y) {
    return rect.contains(x, y);
  }

  /**
   * ʬȡλҶޤ.
   */
  Rectangle getBounds() {
    if (getDataType() == Data.FUNCTOR) {
      Rectangle re = rect;
      Data args[] = getFunctorArguments();
      for (int i = 0; i < args.length; i++) {
	re = re.union(((Node)args[i]).getBounds());
      }
      return re;
    } else {
      return rect;
    }
  }

  /**
   * ʬȡʬλҶΥΡɤư.
   */
  void move(int x, int y) {
    if (getDataType() == Data.FUNCTOR) {
      int dx = x - rect.x;
      int dy = y - rect.y;
      rect.setLocation(x, y);
      Data args[] = getFunctorArguments();
      for (int i = 0; i < args.length; i++) {
	Node arg = (Node)args[i];
	arg.move(arg.rect.x + dx, arg.rect.y + dy);
      }
    } else {
      rect.setLocation(x, y);
    }
  }

  /**
   * ꤵ줿ΡɤʬĤɤĴ٤.
   * ʤʬȤ⿿Ȥ.
   */
  boolean isAncestorOf(Node node) {
    if (this == node)
      return true;

    if (getDataType() == Data.FUNCTOR) {
      Data args[] = getFunctorArguments();
      for (int i = 0; i < args.length; i++) {
	if (((Node)args[i]).isAncestorOf(node))
	  return true;
      }
    }

    return false;
  }

  void replaceData(Data d, Rectangle re, String la) {
    super.replace(d);
    if (re != null) {
      rect = re;
      label = la;
    }

    Node root = this;
    while (!root.isRootNode())
      root = root.parent;
    root.layout();
  }

  /**
   * ʬ겼ΥΡɤκ֤Ԥʤ.
   */
  void layout() {
    if (getDataType() == Data.FUNCTOR) {
      Data args[] = getFunctorArguments();
      int YP = 15;
      int XP = 15;
      int width = - XP;
      for (int i = 0; i < args.length; i++) {
	width += XP;
	Node node = (Node)args[i];
	if (Data.isCons(this) && i == 1) {
	  // cons  cdr 
	  if (rect.width + XP  > width)
	    width = rect.width + XP;
	  node.rect.setLocation(rect.x + width, rect.y);
	} else {
	  node.rect.setLocation(rect.x + width, rect.y + rect.height + YP);
	}
	node.layout();
	Rectangle arg_bound = node.getBounds();
	width += arg_bound.width;
      }
    }
  }

  /**
   * ɲ.
   */
  void addArg(Node node) {
    if (getDataType() == Data.FUNCTOR) {
      String name = this.getFunctorName();
      Data old_args[] = getFunctorArguments();
      Data new_args[] = new Data[old_args.length + 1];
      System.arraycopy(old_args, 0, new_args, 0, old_args.length);
      new_args[old_args.length] = node;

      Data d = Data.Functor(name, new_args);
      node.parent = this;
      replaceData(d, null, null);
    } else if (getDataType() == Data.ATOM) {
      Data d = Data.Functor(this.getAtomName(), new Data[] {node});
      node.parent = this;
      replaceData(d, null, null);
    }
  }

  /**
   * κ.
   */
  void removeArg() {
    if (parent == null || parent.getDataType() != Data.FUNCTOR)
      return;

    Data old_args[] = parent.getFunctorArguments();
    int remove_arg = -1;
    for (int i = 0; i < old_args.length; i++) {
      if ((Node)old_args[i] == this) {
	remove_arg = i;
	break;
      }
    }
    if (remove_arg == -1)
      return;

    String name = parent.getFunctorName();

    if (old_args.length == 1) {
      Data d = Data.Atom(name);
      parent.replaceData(d, null, null);
    } else {
      Data new_args[] = new Data[old_args.length - 1];
      if (remove_arg > 0)
	System.arraycopy(old_args, 0, new_args, 0, remove_arg);
      if (remove_arg + 1 < old_args.length)
	System.arraycopy(old_args, remove_arg + 1,
			 new_args, remove_arg,
			 old_args.length - (remove_arg + 1));

      Data d = Data.Functor(name, new_args);
      parent.replaceData(d, null, null);
    }

    parent = null;
    layout();
  }
}
