// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

import java.util.Vector;

import java.net.*;
import java.io.*;

public class DataIO extends Applet {
  static int default_server_port = 9007;

  private boolean port_enable = false;

  String server_host;   // ФΥۥ̾
  int server_port;  // ФΥݡֹ

  JK jks;

  KDI kdi;
  KDI kdo;
  Button send;
  TextField send_port;

  Button connect;
  Button disconnect;

  List history;
  TextField status_field;

  Vector history_data;

  Frame i_frame;
  Frame o_frame;

  InputStream in;
  OutputStream out;

  Thread thread;

  public DataIO() {
    jks = null;

    setLayout(new BorderLayout(5, 5));
    setBackground(Color.lightGray);

    Object listener = new EventListener();

    // ܥ
    Panel button_panel = new Panel();
    add(button_panel, "North");
    connect = new Button(" connect ");
    connect.addActionListener((ActionListener)listener);
    connect.setEnabled(true);
    button_panel.add(connect);
    disconnect = new Button(" disconnect ");
    disconnect.addActionListener((ActionListener)listener);
    disconnect.setEnabled(false);
    button_panel.add(disconnect);

    // ҥȥ
    Panel history_panel = new Panel(new BorderLayout(3, 3));
    add(history_panel, "Center");
    history_panel.add(new Label(" History :", Label.LEFT), "North");
    history = new List(10);
    history_data = new Vector();
    history.addActionListener((ActionListener)listener);
    history.addItemListener((ItemListener)listener);
    history_panel.add(history, "Center");

    // ơ
    status_field = new TextField("", 30);
    status_field.setEditable(false);
    add(status_field, "South");

    setSize(getPreferredSize());

    // input frame
    i_frame = new Frame("Data Input Frame");
    i_frame.setBackground(Color.lightGray);
    Panel panel1 = new Panel(new FlowLayout(FlowLayout.CENTER, 0 ,0));
    Panel panel2 = new Panel(new FlowLayout(FlowLayout.CENTER, 10 ,0));
    if (port_enable)
      panel2.add(panel1);
    panel1.add(new Label("Port :"));
    send_port = new TextField("0", 5);
    send_port.addActionListener((ActionListener)listener);
    panel1.add(send_port);
    send = new Button(" Send ");
    send.addActionListener((ActionListener)listener);
    send.setEnabled(false);
    panel2.add(send);
    i_frame.add(panel2, "North");
    kdi = new KDI(i_frame);  // add Center
    i_frame.show();

    // output frame
    o_frame = new Frame("Data Output Frame");
    kdo = new KDI(o_frame, false);
    o_frame.show();
  }

  // JKȥ꡼κ
  private void makeJKS() {
    if (jks != null)
      return;

    if (server_host == null || server_host.length() == 0)
      server_host = "localhost";

    try {
      Socket sock;

      sock = new Socket(server_host, server_port);
      in = sock.getInputStream();
      out = sock.getOutputStream();
    } catch(Exception e) {
      setStatus(  "Connection Faild : Error in makeing socket(" + e + ") "
		+ "[connetct to " + server_host + ":" + server_port + "]");
      return;  // ۾ｪλ
    }

    jks = new JK(in, out);

    String str = "Connected : " + server_host + ":" + server_port;

    setStatus(str);
    history_data.addElement(null);
    String message = " -- " + str + " --";
    history.add(message);

    connect.setEnabled(false);
    disconnect.setEnabled(true);
    send.setEnabled(true);

    // ǡɤ߹ߥå
    thread = new GetThread();
    thread.start();
  }

  // JKȥ꡼Ĥ
  protected synchronized void closeJKS() {
    connect.setEnabled(true);
    disconnect.setEnabled(false);
    send.setEnabled(false);

    if (jks == null)
      return;

    jks.close();
    jks = null;

    String str = "Connection closed";
    setStatus(str);
    history_data.addElement(null);
    String message = " -- " + str + " --";
    history.add(message);

    connect.setEnabled(true);
    disconnect.setEnabled(false);
    send.setEnabled(false);

    // close() Τǡjks.get()  null ֤顢
    // åɤϼʬߤΤǡߤɬפϤʤ
    //    if (thread != null && thread.isAlive()) {
    //      thread.stop();
    //    }
  }

  public static void main(String args[]) {
    int server_port = default_server_port;
    String server_host = "localhost";

    if (args.length == 2) {
      server_host = args[0];
      try {
	server_port = Integer.parseInt(args[1]);
      } catch (java.lang.NumberFormatException nfe) {
	System.err.println("usage : java DataIO [<host> <port>]");
	System.exit(1);
      }
    } else if (args.length != 0 && args.length != 2) {
      System.err.println("usage : java DataIO [<host> <port>]");
      System.exit(1);
    }

    DataIO data_io = new DataIO();
    data_io.server_port = server_port;
    data_io.server_host = server_host;

    Frame frame = new Frame("Data I/O");
    frame.add(data_io, "Center");


    Button exit = new Button(" Exit ");
    exit.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	System.exit(0);
      }
    } );
    frame.add(exit, "North");

    frame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
	System.exit(0);
      }
    });

    frame.pack();
    frame.show();
  }

  public void init() {
    server_host = getCodeBase().getHost();

    String server_port_string = getParameter("PORT");
    if (server_port_string != null) {
      try {
	server_port = Integer.parseInt(server_port_string);
      } catch (NumberFormatException e) {
	setStatus("Wrong port number");
	server_port = default_server_port;
      }
    } else {
      server_port = default_server_port;
    }

    makeJKS();
  }

  public void destroy() {
    closeJKS();

    if (i_frame != null)
      i_frame.dispose();

    if (o_frame != null)
      o_frame.dispose();
  }

  class EventListener implements ActionListener, ItemListener {
    public void actionPerformed(ActionEvent event) {
      if (event.getSource() == send) {
	int port;
	try {
	  port = Integer.parseInt(send_port.getText());
	} catch (NumberFormatException e) {
	  port = 0;
	  send_port.setText("0");
	}

	Data d = kdi.getSelectData();
	if (d != null && jks != null) {
	  if (port_enable)
	    jks.put(port, d);
	  else
	    jks.put(d);

	  Data copy_data = Data.clone(d);

	  history_data.addElement(copy_data);
	  String str = "send";
	  if (port_enable)
	    str += "(" + port + ")";
	  str += ":" + Data.toStr(copy_data);
	  history.add(str);
	  //	  history.select(history.getItemCount() - 1);
	  //	  kdo.setData(d);
	}
      } else if (event.getSource() == send_port) {
	try {
	  Integer.parseInt(send_port.getText());
	} catch (NumberFormatException e) {
	  send_port.setText("0");
	}
      } else if (event.getSource() == connect) {
	makeJKS();
      } else if (event.getSource() == disconnect) {
	closeJKS();
      }
    }

    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED) {
	int index = history.getSelectedIndex();
	Data d = (Data)history_data.elementAt(index);
	kdo.setData(d);
      }
    }
  }

  class GetThread extends Thread {
    public void run() {
      for(;;) {
	if (jks == null)
	  return;

	Data d = jks.get();
	if (d == null) {
	  closeJKS();
	  return;
	}

	history_data.addElement(d);
	String str = "receive";
	if (port_enable)
	  str +=  "(_)";
	str += ":" + Data.toStr(d);
	history.add(str);
	history.select(history.getItemCount() - 1);
	history.makeVisible(history.getItemCount() - 1);
	kdo.setData(d);
      }
    }
  }

  private void setStatus(String str) {
    status_field.setText(str);
    status_field.setCaretPosition(0);
  }
}
