// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.event.*;

public abstract class MouseEventWrapper
  implements MouseListener, MouseMotionListener {

  /**
   * ޥƤʤ.
   */
  static final private int NORMAL = 1;

  /**
   * ޥƤ.
   */
  static final private int PRESS  = 2;

  /**
   * ɥå.
   */
  static final private int DRAG   = 3;

  /**
   * ߤΥ⡼.
   */
  private int mode;

  /**
   * ޥݡͥȾˤ뤫ɤΥե饰.
   */
  private boolean on_component;

  /**
   * ľΥޥץ쥹Υ٥.
   * ɸǥեʤɤѤ.
   */
  private MouseEvent pressed_event;


  MouseEventWrapper() {
    on_component = false;
    mode = NORMAL;
  }

  public void mouseClicked(MouseEvent e) {
    // do nothing
    // mouseReleased() ǽԤʤ
  }

  public void mousePressed(MouseEvent e) {
    if (mode != NORMAL) {
      // ץ쥹ɥåϡۤΥץ쥹̵뤹롣
      return;
    }

    if (e.getClickCount() == 1 && isPopupModifier(e)) {
      // ݥåץåץ˥塼ɽ
      mode = NORMAL;
      showPopupMenu(e.getX(), e.getY());
      return;
    } else if (e.getClickCount() > 1 && isPopupModifier(e)) {
      // ֥륯å줿ϡ̵뤹
      mode = NORMAL;
      return;
    }

    if (e.getClickCount() == 1) {
      pressed_event = e;
      mode = PRESS;
      pressed(e);
      return;
    }

    if (e.getClickCount() == 2) {
      pressed_event = e;
      mode = PRESS;
      pressed(e);
      return;
    }

    if (e.getClickCount() > 2) {
      mode = NORMAL;
      return;
    }

    // not reached
  }

  public void mouseReleased(MouseEvent e) {
    if (mode == PRESS) {
      mode = NORMAL;

      if (e.getClickCount() == 2)
	doubleClicked(pressed_event);   // ֥륯å
      else
	clicked(pressed_event);         // 󥰥륯å

      return;
    } else if (mode == DRAG) {
      dragReleased(e, on_component);
      mode = NORMAL;
    }
  }

  public void mouseEntered(MouseEvent e) {
    on_component = true;

    if (mode == NORMAL) {
      moved(e, on_component);
      return;
    } else {
      mouseDragged(e);
      return;
    }
  }

  public void mouseExited(MouseEvent e) {
    on_component = false;

    if (mode == NORMAL) {
      moved(e, on_component);
      return;
    } else {
      mouseDragged(e);
      return;
    }
  }

  public void mouseDragged(MouseEvent e) {
    if (mode == NORMAL) {
      moved(e, on_component);
      return;
    } else if(  mode == PRESS && e.getClickCount() == 0
	      || mode == DRAG) {
      mode = DRAG;
      dragged(e, on_component);
      return;
    }
  }

  public void mouseMoved(MouseEvent e) {
    moved(e, on_component);
  }


  // =================================================================
  // ɬפ˱ơʲΥ᥽åɤ򥵥֥饹ǥХ饤ɤ
  // =================================================================

  /**
   * ܥץ쥹˥ݥåץåץ˥塼ɽ뤫ɤ֤.
   * ޥ֤,ǥեʤɤȤ˥֤֡ͤ.
   * ֥륯åˤ,κǽΥץ쥹˥ݥåץåץ˥塼
   * ɽƤޤΤ,ưζ줬.ä,֥륯å˰
   * ̣ǥեȤ̤Υǥեꤹ.
   */
  protected boolean isPopupModifier(MouseEvent e) {
    return false;
  }

  /**
   * ݥåץåץ˥塼ɽ᥽åɤ򵭽Ҥ.
   */
  protected void showPopupMenu(int ex, int ey) {
  }

  /**
   * ܥ󤬥ץ쥹줿˸ƤФ᥽å.
   * ݥåץåץ˥塼ɽݤ,ȥץ륯åʤɤξ
   * ϸƤФʤ.󥰥륯å,֥륯å,ɥåʤ,Ƥ
   * Υץ쥹˸ƤФ.
   */
  protected void pressed(MouseEvent e) {
  }

  /**
   * åΥ꡼˸ƤФ᥽å.
   * ,ץ쥹Υ٥ȤǤ.
   * 󥰥륯åǤʤ"֥륯å"κǽΥ꡼ˤ
   * ƤФ.
   */
  protected void clicked(MouseEvent e) {
  }

  /**
   * ֥륯åΣܤΥ꡼˸ƤФ.
   * ,ܤΥץ쥹Υ٥ȤǤ.
   * ʤ,ȥץ륯åΣܤΥ꡼ˤƤФΤ.
   * ޤ,֥륯åκǽΣܤΥå,󥰥륯å
   * ǧΤ,󥰥륯åȥ֥륯å̤ΰ̣
   * ˤϤΥ᥽å, clicked() ǹԤʤä
   * 󥻥뤹ɬפ.
   */
  protected void doubleClicked(MouseEvent e) {
  }

  /**
   * ɥåνλΥ꡼˸ƤФ.
   * 󥰥륯åʤ,ɥåǤϤʤΥ꡼ˤϸƤФ
   * . Хǥ꡼礬Τդɬ.
   * ,꡼Υ٥ȤǤ.
   */
  protected void dragReleased(MouseEvent e, boolean on_component) {
  }

  /**
   * ޥư˸ƤФ.
   * ɥåˤϸƤФʤ.ХꤷˤƤФ.
   */
  protected void moved(MouseEvent e, boolean on_component) {
  }

  /**
   * ޥɥå줿˸ƤФ.
   * Хꤷ,ХǤɥå
   * ƤФ.
   */
  protected void dragged(MouseEvent e, boolean on_component) {
  }

}
