// Copyright (C) 1998,1999 Kazuhisa Iizuka

class Stream {
  /**
   * ǡ塼.
   */
  private Queue data;

  /**
   * Ԥ塼.
   */
  private Queue wait;

  /**
   * ǡϤλɤΥե饰.
   */
  private volatile boolean closed;

  /**
   * ȥ꡼.
   */
  public Stream() {
    data = new Queue();
    wait = new Queue();
    closed = false;
  }

  /**
   * ȥ꡼फǡФ.
   * ǡʤ, ɲäԤϤԤ.
   * @return Фǡ, null ξϤ̵򼨤.
   */
  public synchronized Object get() {
    // ¾νԤϡννλԤ
    // Хåե˥ǡ̵ϡǡԤ
    if (!wait.isEmpty() || (data.isEmpty() && !closed)) {
      Thread cur = Thread.currentThread();
      wait.add(cur);  // Ԥ֤̤뤿 Thread Ͽ

      for (;;) {
	try {
	  // put()  close()  notify() Ԥ
	  wait();
	} catch (InterruptedException ie) {
	  // nothing to do
	}

	// ǡʤкƤԤ
	if (data.isEmpty() && !closed)
	  continue;

	// ʬν֤ɤ
	if (wait.getFirst() == cur) {
	  wait.remove();
	  if (closed)
	    notifyAll();  // closed ΤȤ¾ԤäƤ륹åɤ
	  break;
	}
      }
    }

    return data.remove();  // isEmpty() ʤ null
  }

  /**
   * ȥ꡼Ĥ.
   * ʹߤΥǡϤ̵뤵.
   * ǡԤ get()  null ֤.
   */
  public synchronized void close() {
    data.finish();
    closed = true;
    notifyAll();   // λ get()  wait() 
  }

  /**
   * ǡɲä.
   * close() ƤӽФ˸ƤӽФ, Υǡ̵뤵.
   */
  public synchronized void put(Object d) {
    data.add(d);
    notifyAll();   // ǡɲä remove()  wait() 
  }
}
