// Copyright (C) 1998,1999 Kazuhisa Iizuka

/**
 * 塼ɽ饹.
 * ƱޤäƤʤ,
 * ʣΥץ饢ΤϴǤ.
 * ޤ,ǡʤ remove()  null ֤.
 */
public class Queue {
  /**
   * 塼򤢤魯ꥹȤκǽǤؤ.
   * null ʤ, 塼˥ǡ̵򼨤.
   */
  private volatile QueueElement head;

  /**
   * 塼򤢤魯ꥹȤκǸǤؤ.
   */
  private QueueElement tail;

  /**
   * ǡϤλɤΥե饰.
   */
  private volatile boolean finished;

  public Queue() {
    head = null;
    tail = null;
    finished = false;
  }

  /**
   * 塼ǡФ.
   * @return Фǡ
   */
  public Object remove() {
    if (isEmpty())
      return null;

    QueueElement qe = head;
    head = qe.getNext();    // ꥹȤƬΰ֤򹹿
    return qe.getData();    // ꥹȤƬˤäǡ֤
  }

  /**
   * 塼ƬΥǡ򻲾Ȥ.
   * @return ƬΥǡ
   */
  public Object getFirst() {
    if (isEmpty())
      return null;

    return head.getData();    // ꥹȤƬˤäǡ֤
  }

  /**
   * 塼ɲäʹߤʤΤ.
   */
  public void finish() {
    finished = true;
  }

  /**
   * 塼˥ǡ뤫Ĵ٤.
   */
  public boolean isEmpty() {
    if (head == null)
      return true;
    else
      return false;
  }

  /**
   * ǡ򥭥塼ˤ.
   * finish() Ƥ˸ƤӽФƤϤʤʤ.
   */
  public void add(Object d) {
    if (finished)
      return;   // finish() Ƥ顢⤦ɲäʤ
      
    // ǡꥹȤǤ
    QueueElement qe = new QueueElement(d);
    if (isEmpty())
      head = qe;         // ꥹȤƬ
    else
      tail.setNext(qe);  // ꥹȤ˺Ǹɲ

    tail = qe;  // ꥹȤκǸΰ֤ѹ
  }
}

class QueueElement {
  Object data;
  QueueElement next;

  public QueueElement(Object d) { data = d; next = null; }
  public void setNext(QueueElement n) { next = n; }
  public QueueElement getNext() { return next; }
  public Object getData() { return data; }
}
