// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.util.*;

public class ObjectTable {
  private Hashtable table;
  private TagManager tag_m;

  public ObjectTable() {
    table = new Hashtable();
    tag_m = new TagManager();
  }

  // ֥Ȥơ֥ɲä
  public synchronized Data add(Object object) {
    Data tag = tag_m.newTag();
    table.put(tag, new ObjectElement(object));

    return tag;
  }

  // ꤵ줿ĥ֥Ȥ
  // ⤷ʤ null ֤
  public synchronized Object get(Data tag) {
    return table.get(tag);
  }

  // ơ֥뤫
  public synchronized void remove(Data tag) {
    if (table.containsKey(tag)) {
      ObjectElement oe = (ObjectElement)table.get(tag);
      oe.synchronizedCall(null);
      table.remove(tag);
      tag_m.deleteTag(tag);
    }
  }

  // ơ֥뤫ƤΥ֥Ȥ
  public synchronized void removeAll() {
    for (Enumeration elem = table.elements(); elem.hasMoreElements();) {
      ObjectElement element = (ObjectElement)elem.nextElement();
      element.synchronizedCall(null);
    }
    table.clear();
  }
}
