// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.lang.reflect.*;
import java.util.Vector;

public class ObjectElement {
  /**
   * String 饹򤢤魯 Class 饹Υ֥.
   */
  private static final Class STRING_TYPE = new String().getClass();

  Object object;
  Class class_obj;
  private Queue queue;

  // Ū᥽åɤŪեɤ򰷤Υ󥹥ȥ饯
  // synchronizedCall() ϻȤʤ
  ObjectElement(Class cla, Object dummy_ar) {
    object = null;
    class_obj = cla;
  }

  // ֥ȤϿ
  ObjectElement(Object object) {
    if (object == null)
      throw new NullPointerException();

    this.object = object;
    this.class_obj = object.getClass();

    queue = new Queue();
    ObjectThread th = new ObjectThread();
    th.start();
  }

  class ObjectThread extends Thread {
    public void run() {
      Thread th;
      for (;;) {
	synchronized (queue) {
	  if (queue.isEmpty()) {
	    try {
	      queue.wait();  // synchronizedCall()  notify() Ԥ
	    } catch (InterruptedException e) {
	      // nothing to do
	    }
	  }
	  th = (Thread)queue.remove();
	  if (th == null) {
	    return;     // null ξϡåɤλ
	  }
	}

	th.start();

	try {
	  th.join();  // åɤνλԤ
	} catch (InterruptedException e) {
	  // nothing to do
	}
      }
    }
  }

  public void synchronizedCall(Thread th) {
    synchronized(queue) {
      queue.add(th);
      queue.notify();  // class ObjectThread  wait() 
    }
  }


  public static Object makeInstance(String cl, Data args_d[]) throws
      ClassNotFoundException, NoSuchMethodException, SecurityException,
      IllegalAccessException, IllegalArgumentException,
      InstantiationException, InvocationTargetException {

    Class cla = Class.forName(cl);
    // ClassNotFoundException

    Constructor constructor = searchConstructor(cla, args_d);
    // NoSuchMethodException
    // SecurityException

    Object args[] = castArguments(constructor.getParameterTypes(), args_d);

    return constructor.newInstance(args);
    // IllegalAccessException
    // IllegalArgumentException
    // InstantiationException
    // InvocationTargetException
  }

  /**
   * ֥ȥ᥽åɤ¹Ԥ.
   */
  public Data methodInvoke(String method_name, Data args_d[]) throws
      NoSuchMethodException, SecurityException,
      IllegalAccessException, IllegalArgumentException,
      InstantiationException, InvocationTargetException {

    Method method = searchMethod(class_obj, method_name, args_d);
    // NoSuchMethodException
    // SecurityException

    if (!isAssignableFrom(method.getReturnType())) {
      throw new NoSuchMethodException("///");
    }

    Object args[] = castArguments(method.getParameterTypes(), args_d);

    Object ret_obj = method.invoke(object, args);
    // IllegalAccessException
    // IllegalArgumentException
    // InvocationTargetException
    // NullPointerException

    return castToDataClass(ret_obj, method.getReturnType());
  }


  /**
   * եɤͤ.
   */
  public Data getField(String field_name) throws
      NoSuchFieldException, SecurityException, ClassCastException,
      IllegalAccessException, IllegalArgumentException {

    Field field = class_obj.getField(field_name);
    // NoSuchFieldException
    // SecurityException

    if (!isAssignableFrom(field.getType())) {
      throw new ClassCastException();
    }

    Object ret_obj = field.get(object);
    // IllegalAccessException
    // IllegalArgumentException

    return castToDataClass(ret_obj, field.getType());
  }

  /**
   * եɤͤꤹ.
   */
  public void setField(String field_name, Data d) throws
      NoSuchFieldException, SecurityException, ClassCastException,
      IllegalAccessException, IllegalArgumentException {

    Field field = class_obj.getField(field_name);
    // NoSuchFieldException
    // SecurityException

    if (!isAssignableTo(field.getType(), d)) {
      throw new ClassCastException();
    }

    Object set_obj = castDataTo(field.getType(), d);

    field.set(object, set_obj);
    // IllegalAccessException
    // IllegalArgumentException

    return;
  }

  /**
   * Ŭ礹륳󥹥ȥ饯.
   * ⤷, ѥ᥿ Data 饹ΤΤǤʤä, String, Integer .
   * @param class õоݤΥ饹.
   * @param param ѥ᥿ȤͿǡ.
   */
  private static Constructor searchConstructor(Class cla, Data param[])
      throws SecurityException, NoSuchMethodException {

    //----- ޤΤޤŬѤǤΤõ
    try {
      Class param_type[] = new Class[param.length];
      for (int i = 0; i < param.length; i++) {
	param_type[i] = param[i].getClass();
      }
      Constructor constructor = cla.getConstructor(param_type);

      return constructor;      // if successful ...
    } catch (NoSuchMethodException e) {
      // nothing to do
    }
    // SecurityException

    //----- 饹ѤŬ礹뤫ɤĴ٤

    Constructor constructors[] = cla.getConstructors();
    // SecurityException

    for (int i = 0; i < constructors.length; i++) {
      if (checkCasting(constructors[i].getParameterTypes(), param))
	return constructors[i];
    }

    // not found
    throw new NoSuchMethodException();
  }

  /**
   * Ŭ礹᥽åɤ.
   * ⤷, ѥ᥿ Data 饹ΤΤǤʤä, String, Integer .
   * @param class õоݤΥ饹.
   * @param name  õ᥽å̾
   * @param param ѥ᥿ȤͿǡ.
   */
  private static Method searchMethod(Class cla, String name, Data param[])
      throws SecurityException, NoSuchMethodException {

    //----- ޤΤޤŬѤǤΤõ
    try {
      Class param_type[] = new Class[param.length];
      for (int i = 0; i < param.length; i++) {
	param_type[i] = param[i].getClass();
      }
      Method method = cla.getMethod(name, param_type);

      return method;      // if successful ...
    } catch (NoSuchMethodException e) {
      // nothing to do
    }
    // SecurityException

    //----- 饹ѤŬ礹뤫ɤĴ٤

    Method methods[] = cla.getMethods();
    // SecurityException

    for (int i = 0; i < methods.length; i++) {
      if (   methods[i].getName().equals(name)
	  && checkCasting(methods[i].getParameterTypes(), param))
	return methods[i];
    }

    // not found
    throw new NoSuchMethodException();
  }

  /**
   * ꤵ줿ѥ᡼Ŭ礹뤫ɤå.
   */
  private static boolean checkCasting(Class decl[], Data param[]) {
    if (decl.length != param.length)
      return false;

    for (int i = 0; i < decl.length; i++) {
      if (!isAssignableTo(decl[i], param[i]))
	return false;
    }

    return true;
  }

  /**
   * ꤵ줿饹Ŭ礹褦Ѵ,
   * ᥽åɸƤӽФΤΰ.
   */
  private static Object[] castArguments(Class arg_type[], Data args[]) {
    Object[] ret = new Object[arg_type.length];
    for (int i = 0; i < arg_type.length; i++) {
      if (arg_type[i] == Integer.TYPE) {
	ret[i] = new Integer(args[i].getInteger());
      } else if (arg_type[i] == STRING_TYPE) {
	ret[i] = args[i].getString();
      } else {
	ret[i] = (Object)args[i];
      }
    }
    return ret;
  }

  /**
   * Ϳ줿ǡ, ꤵ줿饹˥㥹ȤǤ뤫Ĵ٤.
   */
 private static boolean isAssignableTo(Class cla, Data d) {
    if (cla.isInstance(d))
      return true;
    else if (cla == Integer.TYPE && d.getDataType() == Data.INTEGER)
      return true;
    else if (cla == STRING_TYPE && d.getDataType() == Data.STRING)
      return true;
    else
      return false;
  }

  /**
   * ꤵ줿饹, Data 饹ѴǤ뤫Ĵ٤.
   */
  private static boolean isAssignableFrom(Class cla) {
    if (cla == Integer.TYPE)
      return true;
    else if (cla == STRING_TYPE)
      return true;
    else if (Data.TYPE.isAssignableFrom(cla))
      return true;
    else
      return false;
  }

  /**
   * ꤵ줿֥Ȥ, Data 饹Ѵ.
   * åϤƤʤ.
   */
  private static Data castToDataClass(Object obj, Class cla) {
    if (cla == Integer.TYPE) {
      return  Data.Integer(((Integer)obj).intValue());
    } else if (cla == STRING_TYPE) {
      return Data.String((String)obj);
    } else {
      return (Data)obj;
    }
  }

  /**
   * Data 饹Υ֥Ȥ, ꤵ줿饹˥㥹Ȥ.
   * åϤƤʤ.
   */
  private static Object castDataTo(Class cla, Data d) {
    if (cla == Integer.TYPE) {
      return new Integer(d.getInteger());
    } else if (cla == STRING_TYPE) {
      return d.getString();
    } else {
      return (Object)d;
    }
  }
}
