// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.*;
import java.awt.event.*;

public class InspectorManager extends Frame implements ItemListener {
  public int count = 0;
  private Choice choice;
  private SelectablePanel panel;
  private Label label;

  public InspectorManager() {
    super("Inspector Manager");

    Panel top_panel = new Panel(new FlowLayout(FlowLayout.CENTER, 5, 2));
    label = new Label();
    top_panel.add(label);
    choice = new Choice();
    choice.addItemListener(this);
    top_panel.add(choice);
    add(top_panel, "North");

    panel = new SelectablePanel();
    add(panel, "Center");
  }

  // ItemListener
  public void itemStateChanged(ItemEvent e) {
    panel.selectInspector(choice.getSelectedIndex());
  }

  public void addInspector(Inspector obj) {
    panel.addInspector(obj, count);
    count++;
    choice.add(count+":"+obj.name);
    label.setText("Num:" + count);

    pack();
    setVisible(true);
  }
}

class SelectablePanel extends Panel {
  CardLayout layout;

  SelectablePanel() {
    super();

    layout = new CardLayout();
    setLayout(layout);
  }

  public void addInspector(Inspector obj, int num) {
    add(obj, String.valueOf(num));
  }

  public void selectInspector(int num) {
    layout.show(this, String.valueOf(num));
  }
}
