// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.util.*;

public class ArgsManager {
  private Hashtable table;
  private TagManager tag_m;

  public ArgsManager() {
    this(new TagManager());
  }

  public ArgsManager(TagManager tag_m) {
    table = new Hashtable();
    this.tag_m = tag_m;
  }

  // ³ƤӽФΤΥ֥Ȥ
  public synchronized RetObject newObject() {
    Data tag = tag_m.newTag();
    RetObject obj = new RetObject(tag);
    table.put(tag, obj);

    return obj;
  }

  // ͤꤹ
  public synchronized void setData(Data obj, Data tag) {
    if (table.containsKey(tag)) {
      RetObject element = (RetObject)table.remove(tag);
      element.write(obj);
      tag_m.deleteTag(tag);
    }
  }

  // ͤꤵƤʤƤθƤӽФ null ֤
  public synchronized void close() {
    for (Enumeration elem = table.elements(); elem.hasMoreElements();) {
      RetObject element = (RetObject)elem.nextElement();
      element.write(null);
    }
    table.clear();
  }
}
