// Copyright (C) 1996-1998 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-1292, Japan.
//

import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

public class VStackLayout implements LayoutManager {
	public Dimension preferredLayoutSize(Container target) {
		int totalHeight = 0;
		int maxWidth = 0;
		int n = target.getComponentCount();
		for(int i = 0; i < n; i++) {
			Component m = target.getComponent(i);
			if(m.isVisible()) {
				Dimension pre = m.getPreferredSize();
				totalHeight += pre.height;
				maxWidth = Math.max(pre.width, maxWidth);
			}
		}
		Insets insets = target.getInsets();
		int width = maxWidth + insets.left + insets.right;
		int height = totalHeight + insets.top + insets.bottom;

		return new Dimension(width, height);
	}

	public void layoutContainer(Container target) {
		Insets insets = target.getInsets();
		int width = target.getSize().width - (insets.left + insets.right);
		int nextY = 0;
		int n = target.getComponentCount();

		for(int i = 0; i < n; i++) {
			Component m = target.getComponent(i);
			if(m.isVisible()) {
				Dimension pre = m.getPreferredSize();
				int w = width;
				int h = pre.height;
				int x = insets.left;
				int y = nextY + insets.top;
				m.setBounds(x, y, w, h);
				nextY += h;
			}
		}
	}	// layoutContainer

	public Dimension minimumLayoutSize(Container target) {
		return preferredLayoutSize(target);
	}

	public void addLayoutComponent(String name, Component comp) {
		;	// $B6u(B
	}

	public void removeLayoutComponent(Component comp) {
		;	// $B6u(B
	}
}
/* Takashi Ishikawa / tishi@jaist.ac.jp */
