// Copyright (C) 1996-1998 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-1292, Japan.
//

//
// $BI=<((B

import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

public class ScrollableTable extends Panel {
	Const c = new Const();

	Canvas		table;
	Scrollbar	hbar, vbar;
	Font		titleFont;
	Color		cellColor;
	Color		inputColor;
	Font		inputFont;
	int			rows = 0;
	int			columns = 0;
	Vector		vData;
	int			offsetX = 0, offsetY = 0;
	String		labelRow[];

	// *************
	//	$B=i4|2=(B
	// *************
	public ScrollableTable() {
		cellColor = Color.white;
		inputColor = new Color(100, 100, 225);
		inputFont = new Font("Courier", Font.PLAIN, 10);
		titleFont = new Font("Courier", Font.BOLD, 12);

		createComponents();
		createLayout();
	}	// ScrollableTable

	// ================================================
	public void createComponents() {
		// Component$B$N:n@.$H(Blayout$B@_Dj(B
		hbar = new Scrollbar(Scrollbar.HORIZONTAL);
		vbar = new Scrollbar(Scrollbar.VERTICAL);
		table = new Canvas();
	}

	// ================================================
	public void createLayout() {
		this.setLayout(new BorderLayout(0, 0));

//		this.add("Center", table);
		this.add("South", hbar);
		this.add("East",vbar);

		this.doLayout();	// JDK 1.1.1

		// $B%9%/%m!<%k%P!<@_Dj(B
		setScrollbar(0, 0, rows, columns);
	}


	// ================================================
	//	update
//	public synchronized void update(Graphics g) {
//		;
//	}

	// ================================================
	// $B$Z$$$s$H(B
	public synchronized void paint(Graphics og) {
		Graphics g;
		Dimension d;
		int scWidth, scHeight;

		if(rows == 0 || columns == 0) {
			d = getSize();
			og.setColor(Color.blue);
			og.drawString("Nothing...", d.width / 3, d.height / 3);
			return;
		}

		// $B$=$l$>$l$NIA2hNN0hJ,$K(Bgraphics$B$r8BDj$5$;$k!#(B
		// inset$B$b9MN8$7$J$$$H$^$:$$!#$1$I!"$7$F$J$$!#(B
		d = vbar.getSize();
		scWidth = d.width;
		d = hbar.getSize();
		scHeight = d.height;

		d  = getSize();
		d.width -= scWidth;
		d.height -= scHeight;
		g = og.create(0, Const.cellHeight,
			Const.rowLabelWidth,
			d.height - Const.cellHeight);
		paintRowLabel(g);
		g.dispose();

		g = og.create(Const.rowLabelWidth, 0,
			d.width - Const.rowLabelWidth,
			Const.titleHeight);
		paintColLabel(g);
		g.dispose();

		g = og.create(Const.rowLabelWidth, Const.titleHeight,
			d.width - Const.rowLabelWidth,
			d.height - Const.titleHeight);
		paintTable(g);
		g.dispose();
	}

	// ================================================
	// $B$R$@$j$N$Z$$$s$H(B
	public synchronized void paintRowLabel(Graphics g) {
		Const c = new Const();

		int 	cx, cy;
		int i, j;
		char 	l[] = new char[1];
		Dimension	d = getSize();
		
//		d.width -= Const.cellWidth;
//		d.height = Const.cellHeight;

//		g.clearRect(0, 0, d.width, d.height);

		// ***** table redraw *****
		cx = columns * c.cellWidth + c.rowLabelWidth + (c.cellWidth / 2) - d.width;
		cy = rows * c.cellHeight + (c.cellHeight / 2) - d.height;

		//
		//	$B$3$3$G3F%9%/%m!<%k%P!<$X%5%$%:$H0LCV$rEA$($k!#(B
		//
		// $B2#K@(B
//		g.setColor(inputColor);
//		g.fillRect(0, c.cellHeight, d.width, c.cellHeight);
		g.setFont(titleFont);
		for (i = 0; i < (rows + 1); i++) {
			cy = i * c.cellHeight - offsetY;
			g.setColor(getBackground());
			g.draw3DRect(0, cy, d.width, c.hLineWidth, true);
			if (i < rows && 0 < (cy + c.cellHeight) && cy < d.height) {
				g.setColor(Color.blue);
				g.drawString("" + (i + 1), c.hLineWidth, cy + c.cellHeight - c.hLineWidth);
			}
		}

		// $B=DK@(B
		g.setColor(getBackground());
		g.draw3DRect(0, 0, c.vLineWidth, d.height, true);
		g.draw3DRect(c.rowLabelWidth, 0, c.vLineWidth, d.height, true);

	}	// end of paintRowLabel()

	// ================================================
	// $B$&$($N$Z$$$s$H(B
	public synchronized void paintColLabel(Graphics g) {
		int 	cx, cy;
		int		i, j;
		char 	l[] = new char[1];
		String asTuple[];

		Dimension	d = getSize();

//		d.width = Const.cellWidth;
//		d.height -= Const.cellHeight;

//		g.clearRect(0, 0, d.width, d.height);

		// $B2#K@(B
		g.setFont(titleFont);
		g.setColor(getBackground());
		g.draw3DRect(0, 0, d.width, c.hLineWidth, true);

		// $B=DK@$H%i%Y%k(B
		for (i = 0; i < columns; i++) {
			cx = i * c.cellWidth - offsetX;
			g.setColor(getBackground());
			g.draw3DRect(cx, 0, c.vLineWidth, d.height, true);

			g.setColor(Color.blue);
			g.drawString(labelRow[i], cx + c.hLineWidth, c.titleHeight - c.hLineWidth);
		}
	}	// end of paintColLabel()

	// ================================================
	// $B$^$s$J$+$N$Z$$$s$H(B
	public synchronized void paintTable(Graphics g) {
		Const c = new Const();
		int 	cx, cy;
		int		i, j;
		char 	l[] = new char[1];

		Dimension	d = getSize();
//		d.width -= Const.cellWidth;
//		d.height -= Const.cellHeight;

//		g.clearRect(0, 0, d.width, d.height);


		// ***** table redraw *****
		cx = columns * c.cellWidth + (c.cellWidth / 2) - d.width;
		cy = rows * c.cellHeight + (c.cellHeight / 2) - d.height;
		//setVBar(cy, offsetY);
		//setHBar(cx, offsetX);

		//
		//	$B$3$3$G3F%9%/%m!<%k%P!<$X%5%$%:$H0LCV$rEA$($k!#(B
		//
		// $B2#K@(B
		g.setFont(titleFont);
		for (i = 0; i < (rows + 1); i++) {
			cy = i * c.cellHeight - offsetY;
			g.setColor(getBackground());
			g.draw3DRect(0, cy, d.width, c.hLineWidth, true);
		}

		// $B=DK@(B
		g.setColor(Color.red);
		cy = rows * c.cellHeight + (c.cellHeight / 2);
		for (i = 1; i < columns; i++) {
			cx = i * c.cellWidth - offsetX;
			g.setColor(getBackground());
			if(0 < (cx + c.cellWidth) && cx < d.width) {
				// $BHO0OFb$N$H$-$@$1IA2h$9$k!#(B
				g.draw3DRect(cx, 0, c.vLineWidth, d.height, true);
			}
		}

		if(vData == null) {
			// $B%G!<%?$,$J$$$H$-$O!"$3$3$G$*$7$^$$!#(B
			return;
		}

		// $BFbMF(B
		String str;
		String asTuple[];
		for (i = 0; i < rows; i++) {
			asTuple = (String[])vData.elementAt(i);
			cy = (i + 1) * c.cellHeight - c.hLineWidth - offsetY;
			if(!(0 < (cy + c.cellHeight) && cy < d.height)) {
				continue;
			}
			// $BHO0OFb$N$H$-$@$1!#(B
			for (j = 0; j < columns; j++) {
				cx = (j * c.cellWidth) + c.hLineWidth - offsetX;
				if(0 < (cx + c.cellWidth) && cx < d.width) {
					// $BHO0OFb$N$H$-$@$1IA2h$9$k!#(B
					drawItem(g, i, j, cx, cy, asTuple[j]);
				}
			}
		}
	}	// end of paint()

	public void drawItem(Graphics g, int i, int j, int cx, int cy, String s) {
		g.setColor(Color.red);
		g.drawString(s, cx, cy);
	}


	// ================================================
	//	reshape
	public synchronized void setBounds(int x, int y, int width, int height) {
		super.setBounds(x, y, width, height);
		setScrollbar(offsetX, offsetY, rows, columns);
		this.update(getGraphics());
	}
	
	// ================================================
	//	insets
//	public Insets insets() {
//		return new Insets(2, 2, 2, 2);
//	}

	// *****************************
	//	$B%Q%M%k$N?d>)%5%$%:(B
	// *****************************
	public Dimension getPreferredSize() {
		return new Dimension(500,200);
	}

	// *****************************
	//	$B%Q%M%k$N:G>.%5%$%:(B
	// *****************************
	public Dimension getMinimumSize() {
		return new Dimension(100,100);
	}


	// *****************************
	//	$BI=<($9$k%G!<%?$r<u$1<h$k(B
	// *****************************
	public void setData(Vector v) {

		if(v == null || v.size() == 0) {
			// $B$J$K$b$O$$$C$F$J$$$H$-$O!"$=$N$^$^(Breturn$B!#(B
			rows = 0;
			columns = 0;
			v = new Vector();
		} else {
			// rows$B$H(Bcolumns$B$r7W;;$9$k(B
			vData = v;
			labelRow = (String [])vData.firstElement();	// $B@hF,$O9`L\9T$@$+$i!"(B
			columns = labelRow.length;	// $B@hF,$rJ]B8$7$F!"(B
			vData.removeElementAt(0);	// vData$B$+$i:o=|$9$k!#(B
			rows = vData.size();
		}

		// $B%9%/%m!<%k%P!<:F@_Dj(B	
		setScrollbar(0, 0, rows, columns);
		
		// $B:FIA2h(B
		repaint();
	}



	// ************************
	//	$B%$%Y%s%H=hM}!#(B
	//	$B%9%/%m!<%k%P!<$H$+(B
	// ************************
	public boolean handleEvent(Event e) {
		// 
		int i;

		if(e.target == hbar) {
			// $B2#%9%/%m!<%k%P!<(B
			switch(e.id) {
			case Event.SCROLL_LINE_UP:
			case Event.SCROLL_LINE_DOWN:
			case Event.SCROLL_PAGE_UP:
			case Event.SCROLL_PAGE_DOWN:
			case Event.SCROLL_ABSOLUTE:
				i = ((Integer)e.arg).intValue();
				if(i != offsetX) {
					// $B?t;z$,JQ$o$C$?$H$-$@$1(Bupdate$B$9$k!#(B
					offsetX = i;
					this.update(getGraphics());	
				}
				break;
			}
			return true;

		} else if(e.target == vbar) {
			// $B=D%9%/%m!<%k%P!<(B
			switch(e.id) {
			case Event.SCROLL_LINE_UP:
			case Event.SCROLL_LINE_DOWN:
			case Event.SCROLL_PAGE_UP:
			case Event.SCROLL_PAGE_DOWN:
			case Event.SCROLL_ABSOLUTE:
				i = ((Integer)e.arg).intValue();
				if(i != offsetY) {
					// $B?t;z$,JQ$o$C$?$H$-$@$1(Bupdate$B$9$k!#(B
					setScrollbar(offsetX, i, rows, columns);
					this.update(getGraphics());	
				}
				break;
			}
	
			return true;
/*
		} else if(e.target == table) {
			// $BI=(B
			if(e.id == Event.MOUSE_DOWN) {
				// -- $B$3$3$G2?$+$d$k!#(B
				Point p;
				p = table.myMouseDown(e, e.x, e.y);	// table$B$G$N(BmouseDown$B=hM}!#(B
				// -- $B$3$3$G2?$,A*Br$5$l$F$$$k$+8+$F$b$$$$$J!#(B
				if(p.x != hlPoint.x || p.y != hlPoint.y) {
					// $BA0$H0c$&MWAG$r$5$7$F$$$l$P!"99?7!#(B
					hlPoint = p;
					table.update(table.getGraphics());
				}
				return true;
			}
*/
		}

		// $B$=$N$[$+$N%$%Y%s%H(B
		return super.handleEvent(e);
	}	// processEvent

	
	// *****************************
	//	$B%9%/%m!<%k%P!<:F@_Dj(B
	// ******************************
	public void setScrollbar(int x, int y, int rows, int columns) {
		// scrollbar$B$XEA$($k(B..setValues($B0LCV(B,$BI}(B,$B:G>.CM(B,$B:GBgCM(B)
		Dimension d = getSize(); // table$B%3%s%]!<%M%s%H$N%5%$%:(B($BI}$K$J$k(B)
		Dimension dHBar = hbar.getSize();
		offsetX = x;
		offsetY = y;

		// $B2#%9%/%m!<%k%P!<(B
		hbar.setValues(x, d.width, 0, (columns + 1) * c.cellWidth/*- d.width*/);
		//hbar.setPageIncrement(d.width / 2);
		//hbar.setLineIncrement(c.cellWidth);
		hbar.setBlockIncrement(c.cellWidth);
		hbar.setUnitIncrement(c.cellWidth / 4);

		// $B=D%9%/%m!<%k%P!<(B
		vbar.setValues(y, d.height, 0,
			rows * (c.cellHeight + c.hLineWidth)/* - (d.height - Const.cellHeight - dHBar.height)*/);
		//vbar.setPageIncrement(d.height / 2);
		//vbar.setLineIncrement(c.cellHeight);
		vbar.setBlockIncrement(c.cellHeight * 5);
		vbar.setUnitIncrement(c.cellHeight);
	}


	// $B=D%9%/%m!<%k%P!<$XA4BN$N9b$5$H8=:_0LCV$rEA$($k(B
	public void setVBar(int height, int position) {
		Dimension d = getSize();
		Dimension dHBar = hbar.getSize();
		vbar.setValues(position, d.height - Const.cellHeight - dHBar.height, 0, height);
	}

	// $B=D%9%/%m!<%k%P!<$G$N8=:_0LCV(B
	public int getVBarPosition() {
		return vbar.getValue();
	}

	// $B2#%9%/%m!<%k%P!<$XA4BN$NI}$H8=:_0LCV$rEA$($k(B
	public void setHBar(int width, int position) {
		Dimension d = getSize();
		hbar.setValues(position, d.width, 0, width);
	}

	// $B2#%9%/%m!<%k%P!<$G$N8=:_0LCV(B
	public int getHBarPosition() {
		return hbar.getValue();
	}

	// $B3F<o(Breference


}	// end of ScrollableTable




/* Takashi Ishikawa / tishi@jaist.ac.jp */
