/* $Id: gpage.c,v 1.3 1998/04/19 07:44:27 miyazaki Exp $
 *
 * 				created  by J.Miyazaki 1998.3.23
 * 				modified by J.Miyazaki 1998.3.23
 *
 * Copyright (C) 1996-1998 by Haruo Yokota, 
 *	Japan Advanced Inst. of Sci. and Tech.,
 *	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-1292, Japan.
 */

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <klic/gdobject.h>
#include <klic/gd_macro.h>
#include "atom.h"
#include "funct.h"
#include "gobjdef.h"

#ifdef DIST
#include <klic/interpe.h>
#endif

#define GD_CLASS_NAME() page
#define GD_OBJ_TYPE struct page_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))

#define COND_OBJ(x) ((struct condition_object *)(G_FUNCTORP(x)))
#define PAGE_OBJ(x) ((GD_OBJ_TYPE *)(G_FUNCTORP(x)))

typedef struct {
    long offset;
    long size;
} ProjList;

ProjList projlist[64];

typedef struct {
    long type;
    long offset;
} TypeList;

TypeList typelist[64];

Page *page_buffer = NULL;

GD_USE_CLASS(page);

/********************************************************************/
#define	BUF_ALLOC(BP) { \
    BP = page_buffer; \
    page_buffer = page_buffer->next; \
}
				       
#define	BUF_FREE(BP) { \
    (BP)->next = page_buffer; \
    page_buffer = BP; \
}

void
brk_page_buffer()
{
    int i;
    Page *p;

    for (i = 0; i < BUFFERS; i++) {
	if ((p = (Page *)malloc(sizeof(Page))) == NULL) {
	    fprintf(stderr, "No space for page buffer\n");
	    exit(1);
	}
	p->next = page_buffer;
	page_buffer = p;
    }
}


Condition *
skip_condition(cond)
    Condition *cond;
{
    if (*cond++ == BEGIN) {
	switch (*cond++) {
	case AND: case OR:
	    cond = skip_condition(cond);
	    return skip_condition(cond);

	case EQ: case NE: case LT: case LE: case GT: case GE:
	    cond++;		/* skip cmp type */
	    if (*cond == INTEGER) {
		cond += 2;	/* skip type + int */
	    } else if (*cond == STRING) {
		fprintf(stderr, "skip warn: the first param is string\n");
		cond++;		/* skip type */
		cond += CHAR_ALIGN((strlen((char *)cond) + 1)); /* skip str */
	    } else {
		fprintf(stderr, "skip error\n");
		abort();
	    }
	    if (*cond == INTEGER) {
		cond += 3;	/* skip type + int + end */
	    } else if (*cond == STRING) {
		cond++;		/* skip type */
		cond += CHAR_ALIGN((strlen((char *)cond) + 1));	/* skip str */
		cond++;		/* skip end */
	    } else {
		fprintf(stderr, "skip error\n");
		abort();
	    }
	    return cond;
	    
	case IN:
	    cond++;		/* skip cmp type */
	    if (*cond == INTEGER) {
		cond += 2;	/* skip type + int */
	    } else if (*cond == STRING) {
		fprintf(stderr, "skip warn: the first param is string\n");
		cond++;		/* skip type */
		cond += CHAR_ALIGN((strlen((char *)cond) + 1));	/* skip str */
	    } else {
		fprintf(stderr, "skip error\n");
		abort();
	    }
	    if (*cond == INTEGER) {
		cond += 5;	/* type + int1 + type + int2 + end */
	    } else if (*cond == STRING) {
		cond++;		/* type */
		cond += CHAR_ALIGN((strlen((char *)cond) + 1));	/* str1 */
		cond++;		/* type */
		cond += CHAR_ALIGN((strlen((char *)cond) + 1));	/* str2 */
		cond++;		/* end */
	    } else {
		fprintf(stderr, "skip error\n");
		abort();
	    }
	    return cond;
	}
    }
    fprintf(stderr, "error: skip condtion list\n");
    abort();
}

Boolean
select_test(tuple, cond, next)
    char *tuple;
    Condition *cond, **next;
{    
    long pos, val, constant, constant1;
    Condition *cond1, *cond2, type;
    char *str, *str1;

    if (*cond++ == BEGIN) {
	switch (*cond++) {
	case AND:
	    if (select_test(tuple, cond, &cond1)) {
		if (select_test(tuple, cond1, &cond2)) {
		    /* test succeed */
		    *next = cond2;
		    return TRUE;
		}
	    }
	    return FALSE;

	case OR:
	    if (select_test(tuple, cond, &cond1)) {
		*next = skip_condition(cond1);
		return TRUE;
	    }
	    if (select_test(tuple, cond1, &cond2)) {
		*next = cond2;
		return TRUE;
	    }
	    return FALSE;

	case EQ:
	    type = *cond;	/* compare type */
	    cond += 2;		/* skip compare type and const type */
	    pos = *cond;	/* set position */
	    cond += 2;		/* skip pos + const type */
	    if (type == INTEGER) {
		constant = *cond;	/* set const */
		*next = cond + 2; /* skip const + end */
		BCOPY(tuple + pos, &val, sizeof(long));
		return (val == constant) ? TRUE : FALSE;
	    } else if (type == STRING) {
		str = (char *)cond; /* set str pointer */
		/* skip str + end */
		*next = cond + CHAR_ALIGN(strlen(str) + 1) + 1;
		return (strcmp(tuple + pos, str) == 0) ? TRUE : FALSE;
	    }
	    break;

	case NE:
	    type = *cond;	/* compare type */
	    cond += 2;		/* skip compare type and const type */
	    pos = *cond;	/* set position */
	    cond += 2;		/* skip pos + const type */
	    if (type == INTEGER) {
		constant = *cond;	/* set const */
		*next = cond + 2; /* skip const + end */
		BCOPY(tuple + pos, &val, sizeof(long));
		return (val != constant) ? TRUE : FALSE;
	    } else if (type == STRING) {
		str = (char *)cond; /* set str pointer */
		/* skip str + end */
		*next = cond + CHAR_ALIGN(strlen(str) + 1) + 1;
		return (strcmp(tuple + pos, str) != 0) ? TRUE : FALSE;
	    }
	    break;

	case LE:
	    type = *cond;	/* compare type */
	    cond += 2;		/* skip compare type and const type */
	    pos = *cond;	/* set position */
	    cond += 2;		/* skip pos + const type */
	    if (type == INTEGER) {
		constant = *cond;	/* set const */
		*next = cond + 2; /* skip const + end */
		BCOPY(tuple + pos, &val, sizeof(long));
		return (val <= constant) ? TRUE : FALSE;
	    } else if (type == STRING) {
		str = (char *)cond; /* set str pointer */
		/* skip str + end */
		*next = cond + CHAR_ALIGN(strlen(str) + 1) + 1;
		return (strcmp(tuple + pos, str) <= 0) ? TRUE : FALSE;
	    }
	    break;

	case LT:
	    type = *cond;	/* compare type */
	    cond += 2;		/* skip compare type and const type */
	    pos = *cond;	/* set position */
	    cond += 2;		/* skip pos + const type */
	    if (type == INTEGER) {
		constant = *cond;	/* set const */
		*next = cond + 2; /* skip const + end */
		BCOPY(tuple + pos, &val, sizeof(long));
		return (val < constant) ? TRUE : FALSE;
	    } else if (type == STRING) {
		str = (char *)cond; /* set str pointer */
		/* skip str + end */
		*next = cond + CHAR_ALIGN(strlen(str) + 1) + 1;
		return (strcmp(tuple + pos, str) < 0) ? TRUE : FALSE;
	    }
	    break;

	case GE:
	    type = *cond;	/* compare type */
	    cond += 2;		/* skip compare type and const type */
	    pos = *cond;	/* set position */
	    cond += 2;		/* skip pos + const type */
	    if (type == INTEGER) {
		constant = *cond;	/* set const */
		*next = cond + 2; /* skip const + end */
		BCOPY(tuple + pos, &val, sizeof(long));
		return (val >= constant) ? TRUE : FALSE;
	    } else if (type == STRING) {
		str = (char *)cond; /* set str pointer */
		/* skip str + end */
		*next = cond + CHAR_ALIGN(strlen(str) + 1) + 1;
		return (strcmp(tuple + pos, str) >= 0) ? TRUE : FALSE;
	    }
	    break;

	case GT:
	    type = *cond;	/* compare type */
	    cond += 2;		/* skip compare type and const type */
	    pos = *cond;	/* set position */
	    cond += 2;		/* skip pos + const type */
	    if (type == INTEGER) {
		constant = *cond;	/* set const */
		*next = cond + 2; /* skip const + end */
		BCOPY(tuple + pos, &val, sizeof(long));
		return (val > constant) ? TRUE : FALSE;
	    } else if (type == STRING) {
		str = (char *)cond; /* set str pointer */
		/* skip str + end */
		*next = cond + CHAR_ALIGN(strlen(str) + 1) + 1;
		return (strcmp(tuple + pos, str) > 0) ? TRUE : FALSE;
	    }
	    break;

	case IN:
	    type = *cond;	/* compare type */
	    cond += 2;		/* skip cmp type and const type */
	    pos = *cond;	/* set position */
	    cond += 2;		/* skip pos + const type */
	    if (type == INTEGER) {
		constant = *cond;	/* set const */
		cond += 2;	/* skip const + const type */
		constant1 = *cond;	/* set const1 */
		*next = cond + 2; /* skip const + end */
		BCOPY(tuple + pos, &val, sizeof(long));
		return (constant <= val && val <= constant1) ? TRUE : FALSE;
	    } else if (type == STRING) {
		str = (char *)cond; /* set str pointer */
		cond += CHAR_ALIGN(strlen(str) + 1) + 1;
		str1 = (char *)cond;
		*next = cond + CHAR_ALIGN(strlen(str1) + 1) + 1;
		return (strcmp(str, tuple + pos) <= 0 &&
			strcmp(tuple + pos, str1) <= 0) ? TRUE : FALSE;
	    }
	    break;
	}
    }
    fprintf(stderr, "selection test: parsing error\n");
    abort();
}

Boolean
join_test(tuple1, tuple2, cond, next)
    char *tuple1, *tuple2;
    Condition *cond, **next;
{    
    long pos1, pos2, val1, val2;
    Condition *cond1, *cond2, type;

    if (*cond++ == BEGIN) {
	switch (*cond++) {
	case AND:
	    if (join_test(tuple1, tuple2, cond, &cond1)) {
		if (join_test(tuple1, tuple2, cond1, &cond2)) {
		    /* test succeed */
		    *next = cond2;
		    return TRUE;
		}
	    }
	    return FALSE;

	case OR:
	    if (join_test(tuple1, tuple2, cond, &cond1)) {
		*next = skip_condition(cond1);
		return TRUE;
	    }
	    if (join_test(tuple1, tuple2, cond1, &cond2)) {
		*next = cond2;
		return TRUE;
	    }
	    return FALSE;

	case EQ:
	    type = *cond;
	    cond += 2;		/* skip cmp type + const type */
	    pos1 = *cond;	/* set pos1 */
	    cond += 2;		/* skip const + const type */
	    pos2 = *cond;	/* set pos2 */
	    *next = cond + 2;	/* skip const + end */
	    if (type == INTEGER) {
		BCOPY(tuple1+pos1, &val1, sizeof(long)); /* set val 1 */
		BCOPY(tuple2+pos2, &val2, sizeof(long)); /* set val 2 */
		return (val1 == val2) ? TRUE : FALSE;
	    } else if (type == STRING) {
		return (strcmp(tuple1+pos1, tuple2+pos2) == 0) ? TRUE : FALSE;
	    }
	    break;

	case NE:
	    type = *cond;
	    cond += 2;		/* skip cmp type + const type */
	    pos1 = *cond;	/* set pos1 */
	    cond += 2;		/* skip const + const type */
	    pos2 = *cond;	/* set pos2 */
	    *next = cond + 2;	/* skip const + end */
	    if (type == INTEGER) {
		BCOPY(tuple1+pos1, &val1, sizeof(long)); /* set val 1 */
		BCOPY(tuple2+pos2, &val2, sizeof(long)); /* set val 2 */
		return (val1 != val2) ? TRUE : FALSE;
	    } else if (type == STRING) {
		return (strcmp(tuple1+pos1, tuple2+pos2) != 0) ? TRUE : FALSE;
	    }
	    break;

	case LE:
	    type = *cond;
	    cond += 2;		/* skip cmp type + const type */
	    pos1 = *cond;	/* set pos1 */
	    cond += 2;		/* skip const + const type */
	    pos2 = *cond;	/* set pos2 */
	    *next = cond + 2;	/* skip const + end */
	    if (type == INTEGER) {
		BCOPY(tuple1+pos1, &val1, sizeof(long)); /* set val 1 */
		BCOPY(tuple2+pos2, &val2, sizeof(long)); /* set val 2 */
		return (val1 <= val2) ? TRUE : FALSE;
	    } else if (type == STRING) {
		return (strcmp(tuple1+pos1, tuple2+pos2) <= 0) ? TRUE : FALSE;
	    }
	    break;

	case LT:
	    type = *cond;
	    cond += 2;		/* skip cmp type + const type */
	    pos1 = *cond;	/* set pos1 */
	    cond += 2;		/* skip const + const type */
	    pos2 = *cond;	/* set pos2 */
	    *next = cond + 2;	/* skip const + end */
	    if (type == INTEGER) {
		BCOPY(tuple1+pos1, &val1, sizeof(long)); /* set val 1 */
		BCOPY(tuple2+pos2, &val2, sizeof(long)); /* set val 2 */
		return (val1 < val2) ? TRUE : FALSE;
	    } else if (type == STRING) {
		return (strcmp(tuple1+pos1, tuple2+pos2) < 0) ? TRUE : FALSE;
	    }
	    break;

	case GE:
	    type = *cond;
	    cond += 2;		/* skip cmp type + const type */
	    pos1 = *cond;	/* set pos1 */
	    cond += 2;		/* skip const + const type */
	    pos2 = *cond;	/* set pos2 */
	    *next = cond + 2;	/* skip const + end */
	    if (type == INTEGER) {
		BCOPY(tuple1+pos1, &val1, sizeof(long)); /* set val 1 */
		BCOPY(tuple2+pos2, &val2, sizeof(long)); /* set val 2 */
		return (val1 >= val2) ? TRUE : FALSE;
	    } else if (type == STRING) {
		return (strcmp(tuple1+pos1, tuple2+pos2) >= 0) ? TRUE : FALSE;
	    }
	    break;

	case GT:
	    type = *cond;
	    cond += 2;		/* skip cmp type + const type */
	    pos1 = *cond;	/* set pos1 */
	    cond += 2;		/* skip const + const type */
	    pos2 = *cond;	/* set pos2 */
	    *next = cond + 2;	/* skip const + end */
	    if (type == INTEGER) {
		BCOPY(tuple1+pos1, &val1, sizeof(long)); /* set val 1 */
		BCOPY(tuple2+pos2, &val2, sizeof(long)); /* set val 2 */
		return (val1 > val2) ? TRUE : FALSE;
	    } else if (type == STRING) {
		return (strcmp(tuple1+pos1, tuple2+pos2) > 0) ? TRUE : FALSE;
	    }
	    break;
	}
    }
    fprintf(stderr, "join test:parsing error\n");
    abort();
}

GDDEF_GUNIFY()
{
    G_STD_DECL;

    if (GD_SELF->method_table != GD_OTHER->method_table) {
	GD_GUNIFY_FAIL;
    }
    if (GD_SELF->page_ptr != GD_OTHER->page_ptr) {
	GD_GUNIFY_FAIL;
    }
    GD_GSUCCEED;
}

GDDEF_UNIFY()
{
    G_STD_DECL;

    if (GD_SELF->method_table != GD_OTHER->method_table) {
	GD_UNIFY_FAIL;
    }
    if (GD_SELF->page_ptr != GD_OTHER->page_ptr) {
	GD_UNIFY_FAIL;
    }
    GD_RETURN;
}

GDDEF_GC()
{
    G_STD_DECL;
    GD_OBJ_TYPE *newself;

    GDSET_NEWOBJ_IN_NEWGEN(newself);
    newself->page_ptr = GD_SELF->page_ptr;
    GD_RETURN_FROM_GC(newself);
}

#ifdef DIST
q *decode_page_obj();

GDDEF_ENCODE()
{
    G_STD_DECL;

    PUT_BUFFER(buffer, decode_page_obj);
    if (buffer->wt_index + PAGE_SIZE >= buffer->buf_size) {
	expand_outbuf(buffer);
    }
    BCOPY(GD_SELF->page_ptr->buffer, &(buffer->buffer[buffer->wt_index]),
	  PAGE_SIZE);
    buffer->wt_index += PAGE_SIZE;
    return GENERIC_SUCCEEDED;
}
#endif /* DIST */


GDDEF_METHOD(page__read_2)
{
    G_STD_DECL;
    int rsize, fd;
    q a0 = GD_ARGV[0];

    GD_DEREF(a0);
    fd = G_INTVAL(a0);

    if ((rsize = read(fd, GD_SELF->page_ptr->buffer, PAGE_SIZE)) < 0) {
	perror("read");
	exit(1);
    }
    GD_UNIFY_VALUE(GD_ARGV[1], G_MAKEINT(rsize));
    GD_RETURN;
}    

GDDEF_METHOD(page__write_2)
{
    G_STD_DECL;
    int wsize, fd;
    q a0 = GD_ARGV[0];

    GD_DEREF(a0);
    fd = G_INTVAL(a0);

    if (GD_SELF->page_ptr != NULL) {
	if ((wsize = write(fd, GD_SELF->page_ptr->buffer, PAGE_SIZE)) < 0) {
	    perror("write");
	    exit(1);
	}
    }
    GD_UNIFY_VALUE(GD_ARGV[1], G_MAKEINT(wsize));
    GD_RETURN;
}

GDDEF_METHOD(page__update_2)
{
    G_STD_DECL;
    int wsize, fd;
    q a0 = GD_ARGV[0];

    GD_DEREF(a0);
    fd = G_INTVAL(a0);

    if (GD_SELF->page_ptr != NULL) {
	lseek(fd, -PAGE_SIZE, SEEK_CUR);
	if ((wsize = write(fd, GD_SELF->page_ptr->buffer, PAGE_SIZE)) < 0) {
	    perror("write");
	    exit(1);
	}
    }
    GD_UNIFY_VALUE(GD_ARGV[1], G_MAKEINT(wsize));
    GD_RETURN;
}

GDDEF_METHOD(search__space_2)
{
    G_STD_DECL;
    q a0 = GD_ARGV[0];
    int tsize;
    int i, pos, n;

    GD_DEREF(a0);
    tsize = G_INTVAL(a0);
    n = PAGE_SIZE / (tsize + sizeof(dir_t));

    for (i = 0; i < n; i++) {
	if (GD_SELF->page_ptr->dir[DIR_SIZE - 1 - i] == -1) {
	    /* find space for one */
	    pos = i * tsize;
	    GD_SELF->page_ptr->dir[DIR_SIZE - 1 - i] = pos;
	    GD_UNIFY_VALUE(GD_ARGV[1], G_MAKEINT(pos));
	    GD_RETURN;
	}
    }
    GD_UNIFY_VALUE(GD_ARGV[1], G_MAKEINT(-1));
    GD_RETURN;
}

GDDEF_METHOD(search__tuple_4)
{
    G_STD_DECL;
    q a0 = GD_ARGV[0];
    q a1 = GD_ARGV[1];
    int i, n, pos;

    GD_DEREF(a0);
    GD_DEREF(a1);
    i = G_INTVAL(a0);
    n = G_INTVAL(a1);

    while (i < n) {
	if ((pos = GD_SELF->page_ptr->dir[DIR_SIZE - 1 - i]) != -1) {
	    GD_UNIFY_VALUE(GD_ARGV[2], G_MAKEINT(pos));
	    i++;
	    GD_UNIFY_VALUE(GD_ARGV[3], G_MAKEINT(i));
	    GD_RETURN;
	}
	i++;
    }
    GD_UNIFY_VALUE(GD_ARGV[2], G_MAKEINT(-1));
    GD_UNIFY_VALUE(GD_ARGV[3], G_MAKEINT(-1));
    GD_RETURN;
}

GDDEF_METHOD(put__integer_3)
{
    G_STD_DECL;
    q a0 = GD_ARGV[0];
    q a1 = GD_ARGV[1];
    int val, pos;

    GD_DEREF(a0);
    GD_DEREF(a1);
    val = G_INTVAL(a0);
    pos = G_INTVAL(a1);

    BCOPY(&val, GD_SELF->page_ptr->buffer + pos, sizeof(int));

    GD_UNIFY_VALUE(GD_ARGV[2], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(put__string_3)
{
    G_STD_DECL;
    q a0 = GD_ARGV[0];
    q a1 = GD_ARGV[1];
    char *string;
    int pos;

    GD_DEREF(a0);
    GD_DEREF(a1);    
    string = KLIC2C(a0);
    pos = G_INTVAL(a1);
    BCOPY(string, GD_SELF->page_ptr->buffer + pos, strlen(string)+1);
    GD_UNIFY_VALUE(GD_ARGV[2], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(get__integer_2)
{
    G_STD_DECL;
    q a0 = GD_ARGV[0];
    int pos;
    int val;

    GD_DEREF(a0);
    pos = G_INTVAL(a0);
    BCOPY(GD_SELF->page_ptr->buffer + pos, &val, sizeof(int));
    GD_UNIFY_VALUE(GD_ARGV[1], G_MAKEINT(val));
    GD_RETURN;
}

GDDEF_METHOD(get__string_2)
{
    G_STD_DECL;
    q a0 = GD_ARGV[0];
    int pos;
    char *string;
    q s;
    
    GD_DEREF(a0);
    pos = G_INTVAL(a0);
    string = GD_SELF->page_ptr->buffer + pos;

    s = C2KLIC(string, g_allocp);
    g_allocp = heapp;
    GD_UNIFY_VALUE(GD_ARGV[1], s);
    GD_RETURN;
}

/* (OP TYPE POS CONST) */
GDDEF_METHOD(selection_7)
{
    G_STD_DECL;
    q a0 = GD_ARGV[0];
    q a1 = GD_ARGV[1];
    q a2 = GD_ARGV[2];
    q a3 = GD_ARGV[3];
    q a4 = GD_ARGV[4];    
    int tsize;
    Condition *cond;
    Page *buf;
    int pi, bi;
    dir_t tpos, bpos;
    Condition *dummy;
    int n;

    GD_DEREF(a0);
    tsize = G_INTVAL(a0);
    GD_DEREF(a1);
    cond = COND_OBJ(a1)->ptr;
    GD_DEREF(a2);
    buf = PAGE_OBJ(a2)->page_ptr;
    GD_DEREF(a3);
    pi = G_INTVAL(a3);
    GD_DEREF(a4);
    bi = G_INTVAL(a4);
    
    n = PAGE_SIZE / (tsize + sizeof(dir_t));

    while (pi < n) {
	if ((tpos = GD_SELF->page_ptr->dir[DIR_SIZE - 1 - pi]) != -1) {
	    /* find tuple */
	    if (select_test(GD_SELF->page_ptr->buffer + tpos, cond, &dummy)) {
		/* selection test succeed, copy the tuple */
		bpos = tsize * bi;
		buf->dir[DIR_SIZE - 1 - bi] = bpos; /* mark to dir */
		BCOPY(GD_SELF->page_ptr->buffer + tpos,
		      buf->buffer + bpos, tsize);
		bi++;
		if (bi == n) { /* buffer is full */
		    if (pi == n - 1) { /* page was processed */
			pi = -1;
		    } else {
			pi++;
		    }
		    GD_UNIFY_VALUE(GD_ARGV[5], G_MAKEINT(pi));
		    GD_UNIFY_VALUE(GD_ARGV[6], G_MAKEINT(-1));
		    GD_RETURN;
		}
	    }
	}
	pi++;
    }
    GD_UNIFY_VALUE(GD_ARGV[5], G_MAKEINT(-1));
    GD_UNIFY_VALUE(GD_ARGV[6], G_MAKEINT(bi));
    GD_RETURN;
}

/* (TYPE POS TYPE POS ...) */
GDDEF_METHOD(projection_8)
{
    G_STD_DECL;
    q a0 = GD_ARGV[0];
    q a1 = GD_ARGV[1];
    q a2 = GD_ARGV[2];
    q a3 = GD_ARGV[3];
    q a4 = GD_ARGV[4];
    q a5 = GD_ARGV[5];
    int ptsize, btsize;
    Condition *cond;
    Page *buf;
    int pi, bi;
    dir_t tpos, bpos;
    int p_ntuples;
    int b_ntuples;
    int nitems = 0, i;
    
    GD_DEREF(a0);
    ptsize = G_INTVAL(a0);
    GD_DEREF(a1);
    btsize = G_INTVAL(a1);
    GD_DEREF(a2);
    cond = COND_OBJ(a2)->ptr;
    GD_DEREF(a3);
    buf = PAGE_OBJ(a3)->page_ptr;
    GD_DEREF(a4);
    pi = G_INTVAL(a4);
    GD_DEREF(a5);    
    bi = G_INTVAL(a5);

    p_ntuples = PAGE_SIZE / (ptsize + sizeof(dir_t));
    b_ntuples = PAGE_SIZE / (btsize + sizeof(dir_t));

    if (*cond++ == BEGIN) {
	while (TRUE) {
	    if (*cond == INTEGER) {
		cond++;
		/* position */
		projlist[nitems].offset	= *cond++;
	    } else if (*cond == END) {
		break;
	    } else {
		fprintf(stderr, "project list error\n");
		abort();
	    }
	    if (*cond++ == INTEGER) {
		/* size */
		projlist[nitems].size = *cond++;
	    } else {
		fprintf(stderr, "project list error\n");
		abort();
	    }
	    nitems++;
	}
    } else {
	fprintf(stderr, "project list error\n");
	abort();
    }
	
    while (pi < p_ntuples) {
	if ((tpos = GD_SELF->page_ptr->dir[DIR_SIZE - 1 - pi]) != -1) {
	    /* found a tuple */
	    bpos = btsize * bi;
	    buf->dir[DIR_SIZE - 1 - bi] = bpos; /* mark to dir */
	    /* move attributes */
	    for (i = 0; i < nitems; i++) {
		BCOPY(GD_SELF->page_ptr->buffer + tpos + projlist[i].offset,
		      buf->buffer + bpos, projlist[i].size);
		bpos += projlist[i].size;
	    }
	    bi++;
	    if (bi == b_ntuples) { /* buffer is full */
		if (pi == p_ntuples - 1) { /* page was processed */
		    pi = -1;
		} else {
		    pi++;
		}
		GD_UNIFY_VALUE(GD_ARGV[6], G_MAKEINT(pi));
		GD_UNIFY_VALUE(GD_ARGV[7], G_MAKEINT(-1));
		GD_RETURN;
	    }
	}
	pi++;
    }
    GD_UNIFY_VALUE(GD_ARGV[6], G_MAKEINT(-1));
    GD_UNIFY_VALUE(GD_ARGV[7], G_MAKEINT(bi));
    GD_RETURN;
}

/* (OP TYPE POS POS) */
GDDEF_METHOD(join_11)
{
    G_STD_DECL;
    q a0 = GD_ARGV[0];
    q a1 = GD_ARGV[1];    
    q a2 = GD_ARGV[2];
    q a3 = GD_ARGV[3];
    q a4 = GD_ARGV[4];
    q a5 = GD_ARGV[5];
    q a6 = GD_ARGV[6];
    q a7 = GD_ARGV[7];
    Page *p1, *p2, *buf;
    int tsize1, tsize2;
    Condition *cond, *dummy;
    int i1, i2, bi, ntuples1, ntuples2, bntuples;
    int pos1, pos2, bpos;

    GD_DEREF(a0);
    p2 = PAGE_OBJ(a0)->page_ptr;
    GD_DEREF(a1);
    tsize1 = G_INTVAL(a1);
    GD_DEREF(a2);
    tsize2 = G_INTVAL(a2);
    GD_DEREF(a3);
    cond = COND_OBJ(a3)->ptr;
    GD_DEREF(a4);
    buf = PAGE_OBJ(a4)->page_ptr;
    GD_DEREF(a5);
    i1 = G_INTVAL(a5);
    GD_DEREF(a6);
    i2 = G_INTVAL(a6);
    GD_DEREF(a7);
    bi = G_INTVAL(a7);

    p1 = GD_SELF->page_ptr;
    ntuples1 = PAGE_SIZE / (tsize1 + sizeof(dir_t));
    ntuples2 = PAGE_SIZE / (tsize2 + sizeof(dir_t));
    bntuples = PAGE_SIZE / (tsize1 + tsize2 + sizeof(dir_t));

    while (i1 < ntuples1) {
	if ((pos1 = p1->dir[DIR_SIZE - 1 - i1]) != -1) {
	    while (i2 < ntuples2) {
		if ((pos2  = p2->dir[DIR_SIZE - 1 - i2]) != -1) {
		    if (join_test(p1->buffer+pos1, p2->buffer+pos2,
				  cond, &dummy)) {
			bpos = (tsize1 + tsize2) * bi;
			buf->dir[DIR_SIZE - 1 - bi] = bpos;
			BCOPY(p1->buffer+pos1,buf->buffer+bpos,tsize1);
			BCOPY(p2->buffer+pos2,buf->buffer+bpos+tsize1,tsize2);
			bi++;
			if (bi == bntuples) { /* buf is full */

			    GD_UNIFY_VALUE(GD_ARGV[8], G_MAKEINT(i1));
			    i2++;
			    GD_UNIFY_VALUE(GD_ARGV[9], G_MAKEINT(i2));
			    GD_UNIFY_VALUE(GD_ARGV[10], G_MAKEINT(-1));
			    GD_RETURN;
			}
		    }
		}
		i2++;
	    }
	    i2 = 0;
	}
	i1++;
    }
    GD_UNIFY_VALUE(GD_ARGV[8], G_MAKEINT(-1));
    GD_UNIFY_VALUE(GD_ARGV[9], G_MAKEINT(-1));
    GD_UNIFY_VALUE(GD_ARGV[10], G_MAKEINT(bi));
    GD_RETURN;
}

GDDEF_METHOD(delete_4)
{
    G_STD_DECL;
    Page *p1, *p2;
    q a0 = GD_ARGV[0];
    q a1 = GD_ARGV[1];
    q a2 = GD_ARGV[2];
    Condition *cond;
    long tsize;
    long ntuples;
    long i, j, k, pos1, pos2, nitems = 0;

    GD_DEREF(a0);
    p2 = PAGE_OBJ(a0)->page_ptr;
    GD_DEREF(a1);
    cond = COND_OBJ(a1)->ptr;
    GD_DEREF(a2);
    tsize = G_INTVAL(a2);

    p1 = GD_SELF->page_ptr;
    ntuples = PAGE_SIZE / (tsize + sizeof(dir_t));    

    if (*cond++ == BEGIN) {
        while (TRUE) {
	    if (*cond == END) {
		break;
	    } else {
		typelist[nitems].type = *cond++;
	    }
	    if (*cond++ == INTEGER) {
		typelist[nitems].offset = *cond++;
	    }
	    nitems++;
	}
    }

    for (i = 0; i < ntuples; i++) {
	if ((pos1 = p1->dir[DIR_SIZE - 1 - i]) != -1) {
	    for (j = 0; j < ntuples; j++) {
		if ((pos2 = p2->dir[DIR_SIZE - 1 - j]) != -1) {
		    for (k = 0; k < nitems; k++) {
			if (typelist[k].type == INTEGER) {
			    long val1, val2;
			    BCOPY(p1->buffer+pos1+typelist[k].offset,
				  &val1, sizeof(long));
			    BCOPY(p2->buffer+pos2+typelist[k].offset,
				  &val2, sizeof(long));
			    if (val1 != val2) {
				goto nextj;
			    }
			} else if (typelist[k].type == STRING) {
			    if (strcmp(p1->buffer+pos1+typelist[k].offset,
				       p2->buffer+pos2+typelist[k].offset)
				!= 0) {
				goto nextj;
			    }
			} else {
			    fprintf(stderr, "type list error\n");
			    abort();
			}
		    }
		    p1->dir[DIR_SIZE - 1 - i] = -1;
		    goto nexti;
		}
	      nextj: ;
	    }
	}
      nexti: ;
    }
    GD_UNIFY_VALUE(GD_ARGV[3], GD_OBJ(GD_SELF));
    GD_RETURN;
}


GDDEF_GENERIC()
{
    G_STD_DECL;

    GD_SWITCH_ON_METHOD {
	GD_METHOD_CASE(page__read_2);
	GD_METHOD_CASE(page__write_2);
	GD_METHOD_CASE(page__update_2);
	GD_METHOD_CASE(search__space_2);
	GD_METHOD_CASE(search__tuple_4);
	GD_METHOD_CASE(put__integer_3);
	GD_METHOD_CASE(put__string_3);
	GD_METHOD_CASE(get__integer_2);
	GD_METHOD_CASE(get__string_2);
	GD_METHOD_CASE(selection_7);
	GD_METHOD_CASE(projection_8);
	GD_METHOD_CASE(join_11);
	GD_METHOD_CASE(delete_4);
	GD_METHOD_CASE_DEFAULT;
    }
    GD_RETURN;
}

GDDEF_DEALLOCATE()
{
    BUF_FREE(GD_SELF->page_ptr);
    return 0;
}

#define GDUSE_MY_GUNIFY
#define GDUSE_MY_UNIFY
#define GDUSE_MY_GC
#define GDUSE_MY_GENERIC
#define GDUSE_MY_DEALLOCATE
#ifdef DIST
#define GDUSE_MY_ENCODE
#endif

#include <klic/gd_methtab.h>

GDDEF_NEW()
{
    GD_STD_DECL_FOR_NEW;
    GD_OBJ_TYPE *newobj;
    int i;

    if (GD_ARGC != 0) {
	GD_FAIL("Argument mismatch in page_new");
    }
    GDSET_NEWOBJ_FOR_NEW(newobj, GD_OBJ_SIZE(newobj));
    newobj->method_table = &GD_method_table;
    if (page_buffer == NULL) {
	brk_page_buffer();
    }
    BUF_ALLOC(newobj->page_ptr);
    memset(newobj->page_ptr, (char)-1, PAGE_SIZE);

    /* registor GC method */
    register_for_deallocation(newobj, G_DATA);
    GD_RETURN_FROM_NEW(newobj);
}


#ifdef DIST
void push_decode_stack();

q *
decode_page_obj(inbuf, g_allocp)
    combuf *inbuf;
    q *g_allocp;
{
    G_STD_DECL;
    GD_OBJ_TYPE *newpage;
    q res;

    /*
    fprintf(stdout, "decode(%d)\n", my_node);
    fflush(stdout);
    */
    G_HEAPALLOC_WITH_CHECK(newpage, G_SIZE_IN_Q(GD_OBJ_TYPE), (GD_OBJ_TYPE *),
			   g_allocp, res);

    if (GENERIC_GCREQUEST == res) {
	fprintf(stderr, "decode gc req\n");
	exit(1);
    }

    newpage->method_table = &GD_method_table;
    if (page_buffer == NULL) {
	brk_page_buffer();
    }
    BUF_ALLOC(newpage->page_ptr);

    BCOPY(&(inbuf->buffer[inbuf->rd_index]), newpage->page_ptr->buffer,
	  PAGE_SIZE);
    inbuf->rd_index += PAGE_SIZE;
  
    push_decode_stack((q)makefunctor(newpage));
    return g_allocp;
}
#endif /* DIST */
