/* $Id: gobjdef.h,v 1.2 1998/04/17 12:23:08 miyazaki Exp $
 *
 *			created by  J.Miyazaki 1998.3.23
 *
 * Copyright (C) 1996-1998 by Haruo Yokota, 
 *	Japan Advanced Inst. of Sci. and Tech.,
 *	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-1292, Japan.
 */

#define	PAGE_SIZE	4096
#define	DIR_SIZE	(PAGE_SIZE / sizeof(dir_t))

#define	BUFFERS		128

typedef short	dir_t;
typedef long	Condition;


#define	RATIO		(sizeof(Condition)/sizeof(char))
#define	CHAR_ALIGN(X)	(X + (RATIO - 1) / RATIO)

/* for machines where sizeof(long) = 4 and sizeof(char) = 1 */
/*
#define CHAR_ALIGN(X)	((X + 3) >> 2)
*/

typedef union page_t {
    char buffer[PAGE_SIZE];
    dir_t dir[DIR_SIZE];
    union page_t *next;
} Page;

struct page_object {
    struct data_object_method_table *method_table;
    Page *page_ptr;
};

struct condition_object {
    struct data_object_method_table *method_table;
    long pos;
    long len;
    Condition *ptr;
};

char *convert_klic_string_to_c_string();
q convert_c_string_to_klic_string();

#define KLIC2C convert_klic_string_to_c_string
#define C2KLIC convert_c_string_to_klic_string

typedef enum {
    FALSE,
    TRUE,
} Boolean;

enum {
    BEGIN,
    END,
    AND,
    OR,
    LT,
    LE,
    GT,
    GE,
    EQ,
    NE,
    IN,
    INTEGER,
    STRING,
};
