/* $Id: condition.c,v 1.2 1998/04/17 12:23:08 miyazaki Exp $
 *
 * 				created  by J.Miyazaki 1998.3.30
 * 				modified by J.Miyazaki 1998.4.17
 *
 * Copyright (C) 1996-1998 by Haruo Yokota, 
 *	Japan Advanced Inst. of Sci. and Tech.,
 *	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-1292, Japan.
 */
#include <stdio.h>
#include <string.h>
#include <klic/gdobject.h>
#include <klic/gd_macro.h>
#include "atom.h"
#include "funct.h"
#include "gobjdef.h"

#ifdef DIST
#include <klic/interpe.h>
#endif

#define GD_CLASS_NAME() condition
#define GD_OBJ_TYPE struct condition_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))

GD_USE_CLASS(condition);

#define	INITLEN	8

/********************************************************************/

GDDEF_GUNIFY()
{
    G_STD_DECL;

    if (GD_SELF->method_table != GD_OTHER->method_table) {
	GD_GUNIFY_FAIL;
    }
    if (GD_SELF->pos != GD_OTHER->pos) {
	GD_GUNIFY_FAIL;
    }
    if (GD_SELF->len != GD_OTHER->len) {
	GD_GUNIFY_FAIL;
    }
    if (GD_SELF->ptr != GD_OTHER->ptr) {
	GD_GUNIFY_FAIL;
    }
    GD_GSUCCEED;
}

GDDEF_UNIFY()
{
    G_STD_DECL;

    if (GD_SELF->method_table != GD_OTHER->method_table) {
	GD_UNIFY_FAIL;
    }
    if (GD_SELF->pos != GD_OTHER->pos) {
	GD_UNIFY_FAIL;
    }
    if (GD_SELF->len != GD_OTHER->len) {
	GD_UNIFY_FAIL;
    }
    if (GD_SELF->ptr != GD_OTHER->ptr) {
	GD_UNIFY_FAIL;
    }
    GD_RETURN;
}

GDDEF_GC()
{
    G_STD_DECL;
    GD_OBJ_TYPE *newself;

    GDSET_NEWOBJ_IN_NEWGEN(newself);
    newself->pos = GD_SELF->pos;
    newself->len = GD_SELF->len;
    newself->ptr = GD_SELF->ptr;
    GD_RETURN_FROM_GC(newself);
}

#ifdef DIST
q *decode_page_obj();

GDDEF_ENCODE()
{
    G_STD_DECL;
    int i, count;
    long *p;

    PUT_BUFFER(buffer, decode_condition);
    PUT_BUFFER(buffer, GD_SELF->pos);
    PUT_BUFFER(buffer, GD_SELF->len);
    p = GD_SELF->ptr;
    for (i = 0; i < GD_SELF->len; i++) {
	PUT_BUFFER(buffer, *p++);
    }
    return GENERIC_SUCCEEDED;
}
#endif /* DIST */

GDDEF_METHOD(push__begin_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = BEGIN;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__end_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = END;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__and_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = AND;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__or_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = OR;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__le_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = LE;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__lt_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = LT;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__ge_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = GE;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__gt_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = GT;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__ne_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = NE;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__eq_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = EQ;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__in_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = IN;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}


GDDEF_METHOD(push__integer_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = INTEGER;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__string_1)
{
    G_STD_DECL;

    if (GD_SELF->pos == GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr = (Condition *)realloc(GD_SELF->ptr,
					    GD_SELF->len * sizeof(Condition));
    }
    *(GD_SELF->ptr + GD_SELF->pos) = STRING;
    GD_SELF->pos++;
    GD_UNIFY_VALUE(GD_ARGV[0], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__const_3)
{
    G_STD_DECL;
    q a0 = GD_ARGV[0];
    q a1 = GD_ARGV[1];
    char *t, *str;
    long len;

    GD_DEREF(a0);
    t = KLIC2C(a0);
    GD_DEREF(a1);
    if (strcmp(t, "string") == 0) {
	str = KLIC2C(a1);
	len = strlen(str) + 1;
	if (GD_SELF->pos + CHAR_ALIGN(len) >= GD_SELF->len) {
	    GD_SELF->len += CHAR_ALIGN(len) + INITLEN;
	    GD_SELF->ptr =
		(Condition *)realloc(GD_SELF->ptr,
				     GD_SELF->len * sizeof(Condition));
	}
	BCOPY(str, GD_SELF->ptr + GD_SELF->pos, len);
	GD_SELF->pos += CHAR_ALIGN(len);
    } else if (strcmp(t, "integer") == 0) {
	if (GD_SELF->pos == GD_SELF->len) {
	    GD_SELF->len += INITLEN;
	    GD_SELF->ptr =
		(Condition *)realloc(GD_SELF->ptr,
				     GD_SELF->len * sizeof(Condition));
	}
	*(GD_SELF->ptr + GD_SELF->pos) = G_INTVAL(a1);
	GD_SELF->pos++;
    } else {
	fprintf(stderr, "condition list: type error\n");
	exit(1);
    }
    GD_UNIFY_VALUE(GD_ARGV[2], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_METHOD(push__proj__attr_3)
{
    G_STD_DECL;
    q a0 = GD_ARGV[0];		/* start position */
    q a1 = GD_ARGV[1];		/* end position */
    long *p, start, size;

    GD_DEREF(a0);
    start = G_INTVAL(a0);
    GD_DEREF(a1);
    size = G_INTVAL(a1) - start;

    if (GD_SELF->pos + 4 >= GD_SELF->len) {
	GD_SELF->len += INITLEN;
	GD_SELF->ptr =
	    (Condition *)realloc(GD_SELF->ptr,
				 GD_SELF->len * sizeof(Condition));
    }
    p = GD_SELF->ptr + GD_SELF->pos;
    *p++ = INTEGER;
    *p++ = start;
    *p++ = INTEGER;
    *p++ = size;
    GD_SELF->pos += 4;
    GD_UNIFY_VALUE(GD_ARGV[2], GD_OBJ(GD_SELF));
    GD_RETURN;
}

GDDEF_GENERIC()
{
    G_STD_DECL;

    GD_SWITCH_ON_METHOD {
	GD_METHOD_CASE(push__begin_1);
	GD_METHOD_CASE(push__end_1);
	GD_METHOD_CASE(push__and_1);
	GD_METHOD_CASE(push__or_1);
	GD_METHOD_CASE(push__le_1);
	GD_METHOD_CASE(push__lt_1);
	GD_METHOD_CASE(push__ge_1);
	GD_METHOD_CASE(push__gt_1);
	GD_METHOD_CASE(push__ne_1);
	GD_METHOD_CASE(push__eq_1);
	GD_METHOD_CASE(push__in_1);
	GD_METHOD_CASE(push__integer_1);
	GD_METHOD_CASE(push__string_1);
	GD_METHOD_CASE(push__const_3);
	GD_METHOD_CASE(push__proj__attr_3);
	GD_METHOD_CASE_DEFAULT;
    }
    GD_RETURN;
}

GDDEF_DEALLOCATE()
{
    free(GD_SELF->ptr);
    return 0;
}

#define GDUSE_MY_GUNIFY
#define GDUSE_MY_UNIFY
#define GDUSE_MY_GC
#define GDUSE_MY_GENERIC
#define GDUSE_MY_DEALLOCATE
#ifdef DIST
#define GDUSE_MY_ENCODE
#endif

#include <klic/gd_methtab.h>

GDDEF_NEW()
{
    GD_STD_DECL_FOR_NEW;
    GD_OBJ_TYPE *newobj;
    int i;

    if (GD_ARGC != 0) {
	GD_FAIL("Argument mismatch in page_pointer:new");
    }
    GDSET_NEWOBJ_FOR_NEW(newobj, GD_OBJ_SIZE(newobj));
    newobj->method_table = &GD_method_table;
    newobj->pos = 0;
    newobj->len = INITLEN;
    if ((newobj->ptr =
	 (Condition *)calloc(INITLEN, sizeof(Condition))) == NULL) {
	GD_FAIL("Cannot allocate memory for a page");
    }

    /* registor GC method */
    register_for_deallocation(newobj, G_DATA);
    GD_RETURN_FROM_NEW(newobj);
}


#ifdef DIST
void push_decode_stack();

q *
decode_condition(inbuf, g_allocp)
    combuf *inbuf;
    q *g_allocp;
{
    G_STD_DECL;
    GD_OBJ_TYPE *newobj;
    q res;
    int count;
    Condition *p;

    G_HEAPALLOC_WITH_CHECK(newobj, G_SIZE_IN_Q(GD_OBJ_TYPE), (GD_OBJ_TYPE *),
			   g_allocp, res);

    if (GENERIC_GCREQUEST == res) {
	fprintf(stderr, "decode gc req\n");
	exit(1);
    }

    newobj->method_table = &GD_method_table;
    newobj->pos = (long)GET_BUFFER(inbuf);
    newobj->len = (long)GET_BUFFER(inbuf);
    newobj->ptr = p = (Condition *)calloc(newobj->len, sizeof(Condition));
    for (i = 0; i < newobj->len; i++) {
	*p++ = (long)GET_BUFFER(inbuf);
    }
    push_decode_stack((q)makefunctor(newobj));
    return g_allocp;
}
#endif /* DIST */
