
/*
  Adapted from "travel.lisp", Washington University
  set of problems: ftp.washington.edu/pub/ai/domains_pddl.tgz
  Copyright: 1998, Jorge Lobo.
*/

%==========HEADINGS=====================================

:- multifile causes/3.
:- multifile affects/3.
:- multifile sensing/1.
:- multifile initially/1.
:- multifile initially_unknown/1.
:- multifile axiom/2.

%=======================================================

action(drive(Thing, From, To)) :- 
	thing(Thing), road(From,To),place(From), place(To), 
	diff(From, To).

action(cross(Thing, From, To)) :- 
	thing(Thing), bridge(From,To),place(From), place(To), 
	diff(From, To).

action(board(Person, Place, Vehicle)) :- 
	person(Person), vehicle(Vehicle),
	place(Place),
	diff(Person, Vehicle).

action(disembark(Person, Place, Vehicle)) :-
	person(Person), vehicle(Vehicle), 
	place(Place),
	diff(Person, Vehicle).
	
% =======================================================

thing(Thing) :- vehicle(Thing).
thing(Thing) :- person(Thing).

fluent(at(Thing,From)) :-
	thing(Thing),
	place(From).

fluent(mobile(Thing)) :-
	thing(Thing).

fluent(driving(Person,Vehicle)) :-
	person(Person),
	vehicle(Vehicle).

% =======================================================

possible(drive(Thing, From, _), State) :-
	true_in_state(at(Thing, From), State),
	true_in_state(mobile(Thing), State).

possible(cross(Thing, From, _), State) :- 
	true_in_state(at(Thing, From), State),
	true_in_state(mobile(Thing), State).

possible(board(Person, Place, Vehicle), State) :-
	true_in_state(at(Person, Place), State),
	true_in_state(at(Vehicle, Place),State).

possible(disembark(Person, Place, Vehicle), State) :-
	true_in_state(driving(Person, Vehicle), State),
	true_in_state(at(Vehicle, Place), State).
	
%=======================================================

% No heuristic  --  Easy problems



heuristic(drive(_, _, _), _, _).
heuristic(cross(_, _, _), _, _).
heuristic(board(_, _, _), _, _).
heuristic(disembark(_, _, _), _, _).

%=======================================================

% causes for plan

causes(drive(Thing, From, To), at(Thing, To), []).
causes(drive(Thing, From, To), neg(at(Thing, From)), []).
				
causes(cross(Thing, From, To), at(Thing, To), []).
causes(cross(Thing, From, To), neg(at(Thing, From)), []).
				
causes(board(Person, Place, Vehicle),driving(Person, Vehicle), []).
causes(board(Person, Place, Vehicle), mobile(Vehicle), []).
causes(board(Person, Place, Vehicle), neg(at(Person, Place)), []).
causes(board(Person, Place, Vehicle), neg(mobile(Person)), []).

causes(disembark(Person, Place, Vehicle),at(Person, Place), []).
causes(disembark(Person, Place, Vehicle),mobile(Person), []).
causes(disembark(Person, Place, Vehicle),neg(driving(Person, Vehicle)), []).
causes(disembark(Person, Place, Vehicle),neg(mobile(Vehicle)), []).
	 		 
%=======================================================

/*  Below you can find several initial states and goals.
    Remove the comment signs around the one you would like
    to test.
    At this point the first initial state is uncommented.
*/

%=======================================================
/*	
	place(a). place(b). place(c). place(d). place(e).
	place(f). place(g).
	
	vehicle(bulldozer).
	person(jack).
	
	road(a, b).
	road(b, a).
	road(a, e).
	road(e, a).
	road(e, b).
	road(b, e).
	road(a, c).
	road(c, a).
	road(c, b).
	road(b, c).
	
	bridge(b, d).
	bridge(d, b).
	bridge(c, f).
	bridge(f, c).
	
	road(d, f).
	road(f, d).
	road(f, g).
	road(g, f).
	road(d, g).
	road(g, d).

	initially( mobile(jack) ).
	initially( at(jack, a) ).
	initially( at(bulldozer, e) ).
	
	goal([at(bulldozer, g), at(jack, a)]).
*/

% Plan:  drive(jack,a,e); board(jack,e,bulldozer); drive(bulldozer,e,b);
% cross(bulldozer,b,d); drive(bulldozer,d,g); disembark(jack,g,bulldozer);
% drive(jack,g,f); cross(jack,f,c); drive(jack,c,a);

% ----------------------------------------------------- big-bull2
	
/*
	place(a). place(b). place(c). place(d). place(e).
	place(f). place(g). place(h). place(j).
	place(k). place(l). place(m). place(n).
	
	vehicle(bulldozer).
	person(jack).

	road(a, b).
	road(b, a).
	road(a, c).
	road(c, a).
	road(c, d).
	road(d, c).
	road(d, e).
	road(e, d).
	road(e, j).
	road(j, e).
	road(d, f).
	road(f, d).
	road(f, j).
	road(j, f).
	road(f, k).
	road(k, f).
	road(j, h).
	road(h, j).
	road(h, k).
	road(k, h).
	bridge(k, l).
	bridge(l, k).
	bridge(k, n).
	bridge(n, k).
	road(l, m).
	road(m, l).
	road(m, n).
	road(n, m).
	road(m, g).
	road(g, m).
	road(n, g).
	road(g, n).

	initially( mobile(jack) ).
	initially( at(jack, a) ).
	initially( at(bulldozer, a) ).
	
	goal([at(bulldozer, g)]).
*/
% Plan:  board(jack,a,bulldozer); drive(bulldozer,a,c); drive(bulldozer,c,d);
% drive(bulldozer,d,f); drive(bulldozer,f,k); cross(bulldozer,k,n);
% drive(bulldozer,n,g);

	
% ---------------------------------------- bulldozer (solved)
/*
	place(a). place(b). place(c). place(d). place(e).
	place(f). place(g).  
	
	vehicle(bulldozer).
	person(jack).

	road(a, b).
	road(b, a).
	road(a, e).
	road(e, a).
	road(e, b).
	road(b, e).
	road(a, c).
	road(c, a).
	road(c, b).
	road(b, c).
	bridge(b, d).
	bridge(d, b).
	bridge(c, f).
	bridge(f, c).
	road(d, f).
	road(f, d).
	road(f, g).
	road(g, f).
	road(d, g).
	road(g, d).
	
	initially( mobile(jack) ).
	initially( at(jack, a) ).
	initially( at(bulldozer, a) ). 

	goal([at(bulldozer, g)]).
*/
	

%Plan: [board(jack,a,bulldozer),drive(bulldozer,a,b),
%	cross(bulldozer,b,d),drive(bulldozer,d,g)]

	
% ---------------------------------------- one-way (solved)
	
/*	
	place(a). place(b). place(d). place(e). place(g). 
	
	vehicle(bulldozer).
	person(jack).
	
	road(a, e).
	road(e, b).
	bridge(b, d).
	road(d, g).
	
	initially( at(jack, a) ).
	initially( at(bulldozer, a) ).
	initially( mobile(jack) ).
	
	goal([at(bulldozer, g)]).
	*/
	
 
% Plan: [board(jack,a,bulldozer),drive(bulldozer,a,e),
% drive(bulldozer,e,b),cross(bulldozer,b,d),drive(bulldozer,d,g)]

% ---------------------------------------- dumber-than-dirt(solved)
	
/*
      :- dynamic bridge/2.
	place(a). place(g). 
	
	vehicle(bulldozer).
	person(jack).
	
	road(a, g). 
	
	initially( at(jack, a) ).
	initially( at(bulldozer, a) ).
	initially( mobile(jack) ).
	
	goal([at(bulldozer, g)]).

*/ 
% Plan: [board(jack,a,bulldozer),drive(bulldozer,a,g)]
 	


% ------------------------------------ go-jack (solved)
	
	/*
	place(a). place(b). place(d). place(e). place(g). 
	
	person(jack).
	vehicle(bulldozer).
	
	road(a, e).
	road(e, b).
	bridge(b, d).
	road(d, g).
	
	initially( at(jack, a) ).
	initially( mobile(jack) ).
	
	goal([at(jack, g)]).
	*/
	
 
%Plan: [drive(jack,a,e),drive(jack,e,b),cross(jack,b,d),drive(jack,d,g)]

	
% ---------------------------------get-gack-jack (solved)
	
/*
	place(a). place(b). place(c). place(d). place(e).
	place(f). place(g).  
	
	person(jack).
	vehicle(bulldozer).
	
	road(a, b).
	road(b, a).
	road(a, e).
	road(e, a).
	road(e, b).
	road(b, e).
	road(a, c).
	road(c, a).
	road(c, b).
	road(b, c).
	bridge(b, d).
	bridge(d, b).
	bridge(c, f).
	bridge(f, c).
	road(d, f).
	road(f, d).
	road(f, g).
	road(g, f).
	road(d, g).
	road(g, d).
	
	initially( mobile(jack) ).
	initially( at(jack, a) ).
	initially( at(bulldozer, e) ).

	goal([at(bulldozer, g)]).	
	
*/
% Plan: [drive(jack,a,e),board(jack,e,bulldozer),drive(bulldozer,e,b),
%	cross(bulldozer,b,d),drive(bulldozer,d,g)]
	
% ---------------------------------------- jack-back (solved)
	
/*
        :- dynamic bridge/2.
	place(a). place(g).
	
	vehicle(bulldozer).
	person(jack).

	road(a, g).
	road(g, a). 
	
	initially( mobile(jack) ).
	initially( at(jack, a) ).
	initially( at(bulldozer, a) ).
			
	goal([at(bulldozer, g), at(jack, a)]).
*/ 
% Plan: [board(jack,a,bulldozer),drive(bulldozer,a,g),
% disembark(jack,g,bulldozer),drive(jack,g,a)]
 

% --------------------------------------jack-back2 (solved)
	

        :- dynamic bridge/2.
	place(a). place(e). place(g).
	
	vehicle(bulldozer).
	person(jack).
	
	road(a, e).
	road(e, a).
	road(a, g).
	road(g, a). 
	
	initially( mobile(jack) ).
	initially( at(jack, a) ).
	initially( at(bulldozer, e) ).

	goal([at(bulldozer, g), at(jack, a)]).

% Plan: [drive(jack,a,e),board(jack,e,bulldozer),drive(bulldozer,e,a),
% drive(bulldozer,a,g),disembark(jack,g,bulldozer),drive(jack,g,a)]

