
/*
  Adapted from "montlake.lisp", Washington University
  set of problems: ftp.washington.edu/pub/ai/domains_pddl.tgz
  Copyright: 1998, Jorge Lobo.
*/ 

%==========HEADINGS=====================================

:- multifile causes/3.
:- multifile affects/3.
:- multifile sensing/1.
:- multifile initially/1.
:- multifile initially_unknown/1.
:- multifile axiom/2.
:- multifile goal/1.

  :- dynamic goal/1.
%=======================================================


action(shut_first_gates).
action(shut_second_gates).
action(open_first_gates).
action(open_second_gates).
action(pull_pin).
action(push_pin).
action(switch_semaphore).
action(joe_moves(Here, There)) :- 
	place(Here), place(There), diff(Here, There).
action(open_bridge).
action(close_bridge).

%=======================================================

sensing(look_at_pin).

% =======================================================

fluent(joe_at(Place)) :-
	place(Place).
fluent(bridge_up).
fluent(first_gates_up).
fluent(second_gates_up).
fluent(pin_in).
fluent(boats_waiting).
fluent(semaphore(green)).
fluent(semaphore(yellow)).
fluent(semaphore(red)).
	
% =======================================================

possible(switch_semaphore, State):-
	(true_in_state(semaphore(red),State) 
         -> true_in_state(first_gate_up,State);
            true).

possible(shut_first_gates, State) :- 
	true_in_state(semaphore(red), State).
	
possible(shut_second_gates, State) :- 
	false_in_state(first_gates_up, State).
	
possible(open_first_gates, State) :- 
	true_in_state(second_gates_up, State).
	
possible(open_second_gates, State) :-  
	true_in_state(pin_in, State), true_in_state(joe_at(tower), State).

possible(pull_pin, State) :- 
	all_down_in_state(State), true_in_state(joe_at(pin), State).

possible(push_pin, State) :- 
	all_down_in_state(State), true_in_state(joe_at(pin), State).

possible(joe_moves(Here, _), State) :- 
	true_in_state(joe_at(Here), State).

possible(open_bridge, State) :- 
	all_down_in_state(State), false_in_state(pin_in, State),
	(true_in_state(joe_at(tower), State); 
	 	true_in_state(joe_at(landing), State)).

possible(close_bridge, State) :-
        all_up_in_state(State).

sensing_possible(look_at_pin, State) :-
	unknown_in_state(pin_in, State),
        true_in_state(joe_at(pin), State).


all_up_in_state(State) :- 
	true_in_state(first_gates_up,  State), 
	true_in_state(second_gates_up, State).
	
all_down_in_state(State) :- 
	false_in_state(first_gates_up, State), 
	false_in_state(second_gates_up, State).

%=======================================================

heuristic(joe_moves(H, T), _ , _) :-
	goal(G),
	member(neg(boats_waiting), G),
	(T = landing ; H = landing), !, fail.
	 
% otherwise, no comment
heuristic(joe_moves(_, _), _, _).

heuristic(open_first_gates, State, _) :-
	false_in_state(first_gates_up, State).
	
heuristic(open_second_gates, State, _) :-	
	false_in_state(second_gates_up, State).

heuristic(shut_first_gates, State, _) :-
	true_in_state(first_gates_up, State).

heuristic(shut_second_gates, State, _) :-
	true_in_state(second_gates_up, State).
	
heuristic(pull_pin, State, _) :-
	true_in_state(pin_in, State).

heuristic(push_pin, State, _) :-
	false_in_state(pin_in, State).

heuristic(open_bridge, State, _) :-
	false_in_state(bridge_up, State).
	
heuristic(close_bridge, State, _) :-
	true_in_state(bridge_up, State).

heuristic(switch_semaphore, _, _).


%=======================================================

% Effect propositions

causes(switch_semaphore, 
      neg(semaphore(red)), [semaphore(red)]).

causes(switch_semaphore, 
      semaphore(green), [semaphore(red)]).

causes(switch_semaphore, 
      neg(semaphore(green)), [semaphore(green)]).
      
causes(switch_semaphore, 
      semaphore(yellow), [semaphore(green)]).

causes(switch_semaphore, 
      neg(semaphore(yellow)), [semaphore(yellow)]).

causes(switch_semaphore, 
      semaphore(red), [semaphore(yellow)]).

causes(shut_first_gates, neg(first_gates_up), []).

causes(shut_second_gates, neg(second_gates_up), []).

causes(open_first_gates, first_gates_up, []).

causes(open_second_gates, second_gates_up, []).

causes(pull_pin, neg(pin_in), []).

causes(push_pin, pin_in, []).

causes(joe_moves(Here, There), neg(joe_at(Here)), []).
causes(joe_moves(Here, There),joe_at(There), []).
			
causes(open_bridge, bridge_up, []).
causes(open_bridge,  neg(boats_waiting), []).

causes(close_bridge, neg(bridge_up), []).


%=======================================================

causes_to_know(look_at_pin,pin_in,[]).

%=======================================================

/*
     Initial state sample.  The heuristics for this example are too
weak. Th fist goal runs with no problem with the fluent pin_in either
known or unknown but they take sometime to find the answer.  For the
second goal if pin_in is unknown the system running in an Ultra 1 runs
out of memory.
    
*/

%=======================================================

	place(tower).
	place(landing).
	place(pin).
	
	initially( joe_at(tower) ).
	initially( first_gates_up ).
	initially( second_gates_up ).
%	initially( pin_in ).
	initially_unknown( pin_in ).
	initially( boats_waiting ).
	initially( semaphore(green) ).
	
% This is a simple goal.  To test sensing comment intially(pin_in) and
% remove the comment sign from initially_unknown(pin_in) above.
	
	goal([neg(boats_waiting)]).

/*
Answer when sensing is needed using a compiled planner:

Time needed: 4740
 
Plan: 
 switch_semaphore;
 switch_semaphore;
 shut_first_gates;
 shut_second_gates;
 joe_moves(tower,pin);
 look_at_pin;
 if pin_in then 
    pull_pin;
    joe_moves(pin,tower);
    open_bridge;
 else 
    joe_moves(pin,tower);
    open_bridge;
 

*/

%=======================================================

%  This is the original goal. It finds the answer if the truth value of
%  pin_in is initially known.
%  This is the original goal given in the source where sensing is not allowed.
% 
	
	
%	goal([neg(boats_waiting), semaphore(green)]).
	%

%  The problem with this example is that it does not realize that
% switching the semaphore more than twice in a road does not
% make sense.

	
%===================================================

