/*
   Briefcase problem.  This domain is an example
   for universal quatifiers and for sensing actions.
   Copyright: 1998, Jorge Lobo.

*/


%==========HEADINGS=====================================

:- multifile causes/3.
:- multifile affects/3.
:- multifile sensing/1.
:- multifile initially/1.
:- multifile initially_unknown/1.
:- multifile axiom/2.

%=======================================================


action( move_b(L)) :-  
  location( L).

action( take_out(O)) :-   
  object(O), diff(O, briefcase).

action( put_in(O)) :-  
  object( O), diff(O, briefcase).

%=======================================================

sensing(check_in(O)) :-
	object(O),
	diff(O,briefcase).
%=======================================================

fluent(in(O)) :-
	object(O), diff(O,briefcase).

fluent(at(O,L)) :-
	object(O), location(L).

%=======================================================


heuristic(move_b(_),_,_).
						
heuristic( take_out( X), State, _) :-
  goal( Goal),
  location( L),
  true_in_state( at( X, L), State),
  member( at( X, L), Goal).
						
heuristic( put_in( X), State, _) :-
  object(X),
  location( L),
  true_in_state( at( X, L), State),
  goal( Goal),
  \+ member( at( X, L), Goal).
					 
%====Executavilty conditions =========================================

possible( move_b( L), State) :- 
  location( L0), 
  true_in_state( at( briefcase, L0), State),
  diff( L, L0).
								
possible( take_out( X), State) :- 
  true_in_state( in( X), State),
  location( L),
  true_in_state( at( briefcase, L), State),
  true_in_state( at( X, L), State).
								  
possible( put_in( X), State) :- 
  true_in_state( neg(in( X)), State),
  location( L),
  true_in_state( at( briefcase, L), State),
  true_in_state( at( X, L), State).

sensing_possible(check_in(O), State) :-
	unknown_in_state(in(O), State).

%========Effect propositions====================================

causes(move_b(L),neg(at(briefcase,L0)),[at(briefcase,L0)]).
causes(move_b(L),at(briefcase,L),[]).
causes(move_b(L),at(Object,L),[in(Object)]).
causes(move_b(L),neg(at(Object,L0)),[in(Object), at(Object,L0)]).

causes(put_in(Object),in(Object),[at(briefcase,L),at(Object,L)]).

causes(take_out(Object),neg(in(Object)),[in(Object)]).


%=======Knowledge laws ==========================================

causes_to_know(check_in(O),in(O),[]).

%=======================================================

/*   Sample initial states.
     The first part is the declaration of types
     for the constant used in the domain.
*/

%=======================================================

location( home).
location( office).

object( briefcase).
object( paycheck).
object( dictionary).

initially( at( briefcase, home)).
initially( at( paycheck, home)).
initially( at( dictionary, home)).
initially_unknown( in(paycheck)).


%=======================================================
/*
    Remove the comment signs '%' in front of one of the goals to test the
  example.  You can also add new locations or objects.  Below you will find
  an example with a new location.  You can also add initially_unknown
  for any object different from the briefcase.  This object and the
  briefcase must be in the same location.
*/
%=======================================================

%Goal([at(briefcase,home)]).

%goal([at(briefcase,office)]).

%goal([at(briefcase,office),at(paycheck, office)]).

goal([at(briefcase,office),at(dictionary, office),at( paycheck, home)]).
%Plan: 
%    put_in(dictionary);
%    check_in(paycheck);
%    if in(paycheck) then 
%       take_out(paycheck);
%       move_b(office);
%    else 
%       move_b(office);


%initially_unknown( in(dictionary)).
%goal([at(briefcase,office),at(dictionary, office),at( paycheck, home)]).
/*
Plan: 
 check_in(paycheck);
 if in(paycheck) then 
    take_out(paycheck);
    check_in(dictionary);
    if in(dictionary) then 
       move_b(office);
    else 
       put_in(dictionary);
       move_b(office);
 else 
    check_in(dictionary);
    if in(dictionary) then 
       move_b(office);
    else 
       put_in(dictionary);
       move_b(office);
*/



%location(bank).
%goal([at(paycheck,bank), at(dictionary,office), at(briefcase,home)]).
/*
Plan:
 put_in(dictionary);
 check_in(paycheck);
 if in(paycheck) then 
    move_b(office);
    move_b(bank); 
    take_out(paycheck); 
    move_b(office);
    take_out(dictionary);
    move_b(home);
 else 
    put_in(paycheck); 
    move_b(office);
    take_out(dictionary);
    move_b(bank);
    take_out(paycheck);
    move_b(home);
*/






