/***************************************************************************
* Funtional Interval Arithmetic
*
* FiaMath.h (functions from the mathematical library)
*
* Date:    1 feb 98
* Author:  L. Granvilliers - LIFO Orleans
****************************************************************************/
/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/

#ifndef FIAMATH_H
#define FIAMATH_H

#include <floatingpoint.h>

extern double  ceil();
extern double  floor();
extern double  log2();
extern double  log();
extern double  sqrt();
extern double  cos();
extern double  sin();
extern double  tan();
extern double  exp();
extern double  infinity();
extern int     isinf();
extern int     isnan();
extern double  fabs();


#define FiaR double   /* type of bounds for intervals */

#define FiaSizeLong 32
#define FiaSizeLongMinusOne 31


/****************************************************************************
* IEEE constants
****************************************************************************/
static FiaR FiaInf     =  1/0.0;
static FiaR FiaNegInf  = -1/0.0;
static FiaR FiaPlusInf = +1/0.0;

#define FiaIsInf(x) (isinf(x))   /* Tests if x is equal to the infinity */

#define FiaMaxR      1.797693134862315708e+308  /* Max double */
#define FiaMinR      -FiaMaxR                   /* Min double */
#define FiaNextZero  4.94065645841246544e-324   /* Next double after zero */

#define FiaPi         3.14159265358979323846
#define FiaTwoPi      6.28318530717958647693
#define FiaPiHalf     1.57079632679489661923
#define FiaPiQuarter  0.78539816339744830962


#define FiaAbsR(x) ((x<=0.0) ? -(x) : x)  /* absolute value of x */
#define FiaOddInt(n)  (((n)%2)==1)
#define FiaEvenInt(n) (((n)%2)==0)

#define FiaMinRR(x,y) (((x)<(y))? x : y)
#define FiaMaxRR(x,y) (((x)<(y))? y : x)
#define FiaMinRRRR(x,y,z,t) FiaMinRR(FiaMinRR(x,y),FiaMinRR(z,t))
#define FiaMaxRRRR(x,y,z,t) FiaMaxRR(FiaMaxRR(x,y),FiaMaxRR(z,t))



    static double FiaYYY;
#   define FiaMulRR(x,y) ( isnan(FiaYYY=(x)*(y)) ? 0.0 : FiaYYY )
#   define FiaDivRR(x,y) ( isnan(FiaYYY=(x)/(y)) ? 0.0 : FiaYYY )
#   define FiaMidRR(x,y) ((FiaMaxRR(x,FiaMinR)/2)+(FiaMinRR(FiaMaxR,y)/2))

/*
#   define FiaMulRR(x,y) ( (x)*(y) )
#   define FiaDivRR(x,y) ( (x)/(y) )
#   define FiaMidRR(x,y) ( ((x)+(y))/2 )
*/


#define FiaStrToInt(s)  atoi(s)   /* string to integer */
#define FiaStrToR(s)    atof(s)   /* string to double */
#define FiaStrToLong(s) atol(s)   /* string to long */


/****************************************************************************
* IEEE rounding (source: Sun Release 4.1, mathematical library)
****************************************************************************/
/* extern int     ieee_flags(); */

#include <whichsun.h>

extern double  nextafter();
char *FiaXXX;

/* C rounding for Sun sparc 4, 5 ... */
#ifdef ULTRA
/* ASM rounding for Sun sparc Ultra 2 */

static inline volatile void RoundDownward()  
{
  int cw;
  asm volatile ("st %%fsr,%0" : "=m" (*&cw));
  cw = (cw & 0x3fffffff) | 0xC0000000;
  asm volatile ("ld %0,%%fsr" : : "m" (*&cw));
}

static inline volatile void RoundUpward()  
{
  int cw;
  asm volatile ("st %%fsr,%0" : "=m" (*&cw));
  cw = (cw & 0x3fffffff) | 0x80000000;
  asm volatile ("ld %0,%%fsr" : : "m" (*&cw));
}

#define FiaRoundDown RoundDownward()
#define FiaRoundUp RoundUpward()

#else /* OLD_SPARC */
#define FiaRoundDown ieee_f("set","direction","negative",&FiaXXX)
#define FiaRoundUp   ieee_f("set","direction","positive",&FiaXXX)
#endif

#define FiaNextR(x) nextafter(x,FiaPlusInf)  /* Next double after x */
#define FiaPrevR(x) nextafter(x,FiaNegInf)   /* Previous double after x */

#endif
