/***************************************************************************
* Funtional Interval Arithmetic
*
* FiaInterval.h (basic types and functions)
*
* Date:    1 feb 98
* Author:  L. Granvilliers - LIFO Orleans
****************************************************************************/
/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/

#ifndef FIAITV_H
#define FIAITV_H

#include "FiaMath.h"
#include <stdio.h>
#include <bssolve.h>


/****************************************************************************
* Interval : type, macros
****************************************************************************/

typedef struct
{      FiaR left;
       FiaR right;
} FiaBounds;
typedef FiaBounds FiaItv[1];

#define FiaMinI(i)  i[0].left
#define FiaMaxI(i)  i[0].right


#define FiaEmptyI(i)     ((FiaMinI(i)>FiaMaxI(i)) ? 1 : 0)
#define FiaNotEmptyI(i)  ((FiaMinI(i)>FiaMaxI(i)) ? 0 : 1)
#define FiaIeqI(i1,i2)\
   ((FiaMinI(i1)==FiaMinI(i2)) && (FiaMaxI(i1)==FiaMaxI(i2)))

#define FiaIdiffI(i1,i2)\
   ((FiaMinI(i1)!=FiaMinI(i2)) || (FiaMaxI(i1)!=FiaMaxI(i2)))

#define FiaRinI(i,x)     (((x<FiaMinI(i)) || (x>FiaMaxI(i))) ? 0 : 1)
#define FiaFloatI(i)    (FiaMinI(i)==FiaMaxI(i))

#define FiaWidthI(i)  (FiaMaxI(i)-FiaMinI(i))
#define FiaCanonicalI(i)  (FiaMaxI(i)<=FiaNextR(FiaMinI(i)))
#define FiaPreciseI(i,prec)  (FiaMaxI(i)<=(FiaNextR(FiaMinI(i)+prec)))

#define FiaSetEmptyI(i)  (FiaMaxI(i) = FiaNegInf)
#define FiaSetRR(i,x1,x2)  FiaMinI(i)=x1 ; FiaMaxI(i)=x2

#define FiaMidI(i)  FiaMidRR(FiaMinI(i),FiaMaxI(i))


#define FiaItvZero(i) ( (FiaMinI(i)==0.0) && (FiaMaxI(i)==0.0) )



#define FiaWidthReduction(i,j) ((FiaMinI(j)-FiaMinI(i))+(FiaMaxI(i)-FiaMaxI(j)))



#define FiaCanonicalNarI(i) (FiaMaxI(i)<=(FiaNextR(FiaMinI(i))))

/*#define FiaCanonicalNarI(i) FiaPreciseI(i,PragmaBoxPrecision)*/

#define FiaIsImproved(i1,i2) (FiaWidthI(i2)<(FiaWidthI(i1)*PragmaImprovement))


/****************************************************************************
* Interval : functions
****************************************************************************/

#define FiaCopyI(i,Source)                 \
             FiaMinI(i) = FiaMinI(Source); \
             FiaMaxI(i) = FiaMaxI(Source)
#define FiaFreeI(i) free(i)

FiaBounds *FiaNewI();
FiaBounds *FiaNewLargestI();
FiaBounds *FiaNewCopyI(FiaItv i);
FiaBounds *FiaNewRRtoI(FiaR x1, FiaR x2);

void FiaToLargestI     (FiaItv i);
void FiaToIntegerI     (FiaItv i);
void FiaAbsI           (FiaItv Result, FiaItv i);
void FiaInterII        (FiaItv Result, FiaItv i1, FiaItv i2);
int  FiaIsEqualInterII (FiaItv Result, FiaItv i1, FiaItv i2);
void FiaWriteI         (FILE *out, FiaItv i, int digits);

typedef void (* FiaEvalOpI)(FiaItv, FiaItv, FiaItv);

void FiaAddII    (FiaItv Result, FiaItv i1, FiaItv i2);
void FiaAddRI    (FiaItv Result, FiaItv x,  FiaItv i);
void FiaSubII    (FiaItv Result, FiaItv i1, FiaItv i2);
void FiaSubRI    (FiaItv Result, FiaItv x,  FiaItv i);
void FiaSubIR    (FiaItv Result, FiaItv i,  FiaItv x);
void FiaNegI     (FiaItv Result, FiaItv i,  FiaItv useless);
void FiaMulII    (FiaItv Result, FiaItv i1, FiaItv i2);
void FiaMulRI    (FiaItv Result, FiaItv x,  FiaItv i);
void FiaMulRnegI (FiaItv Result, FiaItv x,  FiaItv i);
void FiaMulRposI (FiaItv Result, FiaItv x,  FiaItv i);
void FiaDivII    (FiaItv Result, FiaItv i1, FiaItv i2);
void FiaDivIR    (FiaItv Result, FiaItv i,  FiaItv x);
void FiaDivRI    (FiaItv Result, FiaItv x,  FiaItv i);
void FiaDivIRneg (FiaItv Result, FiaItv i,  FiaItv x);
void FiaDivIRpos (FiaItv Result, FiaItv i,  FiaItv x);
void FiaDivRnegI (FiaItv Result, FiaItv x,  FiaItv i);
void FiaDivRposI (FiaItv Result, FiaItv x,  FiaItv i);
void FiaSqrI     (FiaItv Result, FiaItv i,  FiaItv useless);
void FiaSqrtI    (FiaItv Result, FiaItv i,  FiaItv useless);
void FiaPowI     (FiaItv Result, FiaItv i,  FiaItv n);
void FiaExpI     (FiaItv Result, FiaItv i,  FiaItv useless);
void FiaLogI     (FiaItv Result, FiaItv i,  FiaItv useless);


void FiaDivRposIinternal (FiaItv Result, FiaR x, FiaItv i);
void FiaPowIinternal     (FiaItv Result, FiaItv i, int n);
void FiaMulRposIinternal (FiaItv Result, FiaR x, FiaItv i);


FiaEvalOpI FiaInvOpI(FiaEvalOpI op);

BssValue *Fia2Bss( FiaItv i);

#endif
