/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#ifndef VARS_H
#define VARS_H

#include <stdio.h>
#include <value.h>
#include <reps.h>

typedef struct {
  /*  char *name; */
  int name;
  unsigned int loc;
  BssValue *value;
  LRep *ext;
  char most_recent[9];
} BssVar;

#define VarName( v)       ((v)->name)
#define VarLoc( v)        ((v)->loc)
#define VarExt( v)     ((v)->ext)
#define VarMostRecent( v) ((v)->most_recent)

BssValue *VarValue( BssVar *v);

BssVar *VarAllocInit( /*char **/ int name, int loc, BssValue value);
/* The two following functions return a pointer to the address of the
   stored value */
#define VarAddRep( v, rep, value) LRepInsert( VarExt( v), rep, value)
#define VarGetRep( v, rep) LRepFind( VarExt( v), rep)

/* The two following functions return a pointer to the old value */
void *VarUpdateRep( BssVar *v, char *rep, void *value);
BssValue *VarUpdate( BssVar *v, BssValue *value);

#define VarWhichRep( v) LRepWhich( VarExt( v))

/* Propagates the changes made by the last modifier into the BssValue */
void VarNormalizeRep( BssVar *v);

void VarFree( BssVar *v, void (*rfree)( void *));
#define VarWrite( f, v) fprintf( f, "%d@%d", VarName( (BssVar*)v), VarLoc( (BssVar*)v));

char *Var2bstring( BssVar *v, int *length);
BssVar *bstring2Var( char *s);

#endif
