/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#ifndef HTABLE_H
#define HTABLE_H

#include <stdio.h>

struct hentry {
  char *name;
  void *info;
  struct hentry *next;
};

struct table {
  unsigned long size;
  struct hentry **t;
};

typedef struct table htable;

htable *hinit( unsigned long size);
void *hinsert(htable *t, char *s, void *v);
void *hfind(htable *t, char *s);
void *hreplace(htable *t, char *s, void *v);
void *hremove(htable *t, char *s);
void hfree( htable *t, void (*efree)( void *));
void hprint( FILE *f, htable *t, void (*eprint)( FILE*, void *));

#endif
