/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/


#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>

#include "value.h"
#include "integer.h"
#include "float.h"
#include "interval.h"
#include "infinity.h"


#define LIBERE

#define BssApplyOp1( Op, v, v1)\
{\
  BssSetType( v, BssGetType( v1));\
  switch (BssGetType(v1)) {\
    case Integer:\
       BssValIntRef( v) = realloc(       BssValIntRef( v), sizeof( BssIntType));\
IntInit(BssValIntRef( v));\
      Int##Op( BssValInt( v), BssValInt(v1));\
      break;\
    case Rational:\
       BssValRatRef( v) = realloc(       BssValRatRef( v), sizeof( BssRatType));\
RatInit(BssValRatRef( v));\
      Rat##Op( BssValRat( v), BssValRat(v1));\
      break;\
    case Float:\
       BssValFltRef( v) = realloc(       BssValFltRef( v), sizeof( BssFltType));\
FltInit(BssValFltRef( v));\
      Flt##Op( BssValFlt( v), BssValFlt(v1));\
      break;\
    case Minus_infinity:\
    case Plus_infinity:\
       BssValInfRef( v) = realloc(       BssValInfRef( v), sizeof( BssInfType));\
InfInit(BssValInfRef( v));\
      Inf##Op( BssValInf( v), BssValInf(v1));\
      break;\
    }\
  }\
/*      
    case Interval:\
       BssValItvRef( v) = realloc(       BssValItvRef( v), sizeof( BssItvType));\
ItvInit(BssValItvRef( v));\
      Itv##Op( BssValItv( v), BssValItv(v1));\
      break;\
    case Union_of:\
       BssValUofRef( v) = realloc(       BssValUofRef( v), sizeof( BssUofType));\
UofInit(BssValUofRef( v));\
      Uof##Op( BssValUof( v), BssValUof(v1));\
      break;\
*/

#define BssApplyOp2( Op, v, v1, v2)\
{\
  BssValueP *fault;\
  if (BssGetType( v1) == BssGetType( v2)) {\
    BssSetType( v, BssGetType( v1));\
  switch (BssGetType(v1)) {\
    case Integer:\
       BssValIntRef( v) = realloc(       BssValIntRef( v), sizeof( BssIntType));\
IntInit(BssValIntRef( v));\
      Int##Op( BssValInt( v), BssValInt(v1), BssValInt(v2));\
      break;\
    case Rational:\
       BssValRatRef( v) = realloc(       BssValRatRef( v), sizeof( BssRatType));\
RatInit(BssValRatRef( v));\
      Rat##Op( BssValRat( v), BssValRat(v1), BssValRat(v2));\
      break;\
    case Float:\
       BssValFltRef( v) = realloc(       BssValFltRef( v), sizeof( BssFltType));\
FltInit(BssValFltRef( v));\
      Flt##Op( BssValFlt( v), BssValFlt(v1), BssValFlt(v2));\
      break;\
    case Minus_infinity:\
    case Plus_infinity:\
       BssValInfRef( v) = realloc(       BssValInfRef( v), sizeof( BssInfType));\
InfInit(BssValInfRef( v));\
      Inf##Op( BssValInf( v), BssValInf(v1), BssValInf(v2));\
      break;\
    }\
  }\
  else {\
    if (BssOrderType( v1, v2) < 0) {\
      i = v1;\
      s = v2;\
    }\
    else {\
      i = v2;\
      s = v1;\
    }\
    BssSetType( v, BssGetType( s));\
    switch(BssGetType(s)) {\
    case Rational:\
			     printf("Rational\n");\
       BssValRatRef( v) = realloc(       BssValRatRef( v), sizeof( BssRatType));\
RatInit(BssValRatRef( v));\
      Rat##Op( BssValRat( v), RatAllocInit( IntVal(BssValInt( i)), 1),\
	       BssValRat(s));\
      break;\
    case Float:\
			     printf("Float\n");\
       BssValFltRef( v) = realloc(       BssValFltRef( v), sizeof( BssFltType));\
FltInit(BssValFltRef( v));\
      if (BssIsInt( i))\
	Flt##Op( BssValFlt( v), FltAllocInit( (double)(IntVal( BssValInt(i)))),\
		       BssValFlt( s));\
      else\
	Flt##Op( BssValFlt( v), FltAllocInit( Rat2double( BssValRat( i))),\
		       BssValFlt( s));\
      break;\
	      default:\
	      printf("default\n");BssWrite(stdout, s, 1);\
    }\
  }\
}
/* if the type are the same */
/*      
    case Interval:\
       BssValItvRef( v) = realloc(       BssValItvRef( v), sizeof( BssItvType));\
ItvInit(BssValItvRef( v));\
      Itv##Op( BssValItv( v), BssValItv(v1), BssValItv(v2));\
      break;\
    case Union_of:\
       BssValUofRef( v) = realloc(       BssValUofRef( v), sizeof( BssUofType));\
UofInit(BssValUofRef( v));\
      Uof##Op( BssValUof( v), BssValUof(v1), BssValUof(v2));\
      break;\
*/
/* else */
/*
    case Interval:\
       BssValItvRef( v) = realloc(       BssValItvRef( v), sizeof( BssItvType));\
ItvInit(BssValItvRef( v));\
      Itv##Op( ItvValRat( v), ItvAllocInit( i, i, 1, 1),\
		     BssValItv( s));\
      break;\
    case Union_of:\
       BssValUofRef( v) = realloc(       BssValUofRef( v), sizeof( BssUofType));\
UofInit(BssValUofRef( v));\
      Uof##Op( ItvValRat( v), UofAllocInit( fault, 1, i),\
		     BssValUof( s));\
      break;\
*/
int BssOrderType( BssValue v1, BssValue v2)
{
  if (BssGetType( v1) < BssGetType( v2)) 
    return -1;
  else if (BssGetType( v1) == BssGetType( v2))
    return 0;
  else
    return 1;
}

void BssFreeValue( BssValue v)
{
  switch (BssGetType( v)) {
  case Integer:
    IntFree( BssValIntRef(v));
    break;

  case Rational:
    RatFree( BssValRatRef(v));
    break;

  case Float:
    FltFree( BssValFltRef(v));
    break;

  case Interval:
    ItvFree( BssValItvRef(v));
    break;
/*
  case Union_of:
    UofFree( BssValUofRef(v));
    break;
*/
  case Minus_infinity:
  case Plus_infinity:    
    InfFree( BssValInfRef(v));
    break;
  }
}

BssValueP BssAlloc()
{
  BssValueP v;
  v = (BssValueP)malloc( sizeof(BssValueType));
  BssInit(v);
/*   BssSetType(v, Interval);
  (BssValueP)BssValItv(v) = ItvAlloc();
  ItvSetMaxRange( BssValItv( v)); */

  return v;
}

BssValueP BssAllocInit( const enum BssType type, ...)
{
  va_list args;
  BssValueP v;

  va_start( args, type);
  
  /*  v = (BssValueP)malloc(sizeof( BssValueType)); */
  v = BssAlloc();
  BssSetType(v,type);
  
  switch (type) {
  case Integer:
    BssValIntRef(v) = (void*)IntAllocInit( va_arg( args, signed long));
    break;

  case Rational:
    BssValRatRef(v) = (void*)RatAllocInit( va_arg( args, signed long), va_arg(
								  args, signed long));
    break;

  case Float:
    BssValFltRef(v) = (void*)FltAllocInit( va_arg( args, double));
    break;

  case Interval:
    BssValItvRef(v) = (void*)ItvAllocInit(va_arg( args, BssValueP),
			    va_arg( args, BssValueP),
			    va_arg( args, int), va_arg( args, int));
    break;
/*
  case Union_of:
    BssValUofRef(v) = (void*)UofAllocInitVargs( &args);
    break;
*/
  case Minus_infinity:
    BssValInfRef(v) = (void*)InfAllocInit( MinusInf);
    break;
  case Plus_infinity:    
    BssValInfRef(v) = (void*)InfAllocInit( PlusInf);
    break;
}
  va_end(args);
  return v;
}

void BssSet( BssValue v, const enum BssType type, ...)
{
  va_list args;

  va_start( args, type);

  if (BssGetType( v) != type || !BssValP( v)) {
    BssSetType((v),type);
    if (BssValP( v))
      BssFreeValue( v);
    
    switch (type) {
    case Integer:
      BssValIntRef(v) = (void*)IntAllocInit( va_arg( args, signed long));
      break;
      
    case Rational:
      BssValRatRef(v) = (void*)RatAllocInit( va_arg( args, signed long), va_arg(
								   args, signed long));
      break;
      
    case Float:
      BssValFltRef(v) = (void*)FltAllocInit(va_arg( args, double));
      break;
      
    case Interval:
      BssValItvRef(v) = (void*)ItvAllocInit(va_arg( args, BssValueP),
				 va_arg( args, BssValueP),
				 va_arg( args, int), va_arg( args, int));
      break;
/*      
    case Union_of:
      BssValUofRef(v) = (void*)UofAllocInitVargs( &args);
      break;
*/      
    case Minus_infinity:
      BssValInfRef(v) = (void*)InfAllocInit( MinusInf);
      break;
    case Plus_infinity:
      BssValInfRef(v) = (void*)InfAllocInit( PlusInf);
      break;
    }
    va_end(args);
  }
  else { /*BssGetType(v) == type*/
    switch (type) {
    case Integer:
      IntSet( BssValInt(v), va_arg( args, signed long));
      break;
      
    case Rational:
      RatSet( BssValRat(v), va_arg( args, signed long),
	      va_arg( args, unsigned long));
      break;
      
    case Float:
      FltSet( BssValFlt(v), va_arg( args, double));
      break;
      
      case Interval:
	ItvSet( BssValItv(v),
		va_arg( args, BssFltP),
		va_arg( args, BssFltP),
		va_arg( args, int), va_arg( args, int));
      break;
/*      
    case Union_of:
      UofSet( BssValUof(v), UofAllocInitVargs( &args);
      break;
*/      
    case Minus_infinity:
      InfSet( BssValInf(v), MinusInf);
      break;
    case Plus_infinity:
      InfSet( BssValInf(v), PlusInf);
      break;
    }
    va_end(args);
  }
    
}

BssValueP BssAllocCopy( const BssValue v1)
{
  BssValueP v;
  
  /*   v = (BssValueP)malloc(sizeof( BssValueType)); */
  v = BssAlloc();
  BssInit(v);
  BssCopy( v, v1);
  return v;
}

void BssCopy( BssValue v, const BssValue v1)
{
  
  BssSetType((v),BssGetType(v1));

  if (BssValRef(v))
    switch (BssGetType(v1)) {
    case Integer:
       BssValIntRef(v) = realloc( BssValIntRef(v), sizeof(BssIntType));
IntInit(BssValIntRef(v));
      IntCopy( BssValInt(v), BssValInt( v1));
      break;
      
    case Rational:
       BssValRatRef(v) = realloc( BssValRatRef(v), sizeof(BssRatType));
RatInit(BssValRatRef(v));
      RatCopy( BssValRat(v),BssValRat( v1));
      break;
      
    case Float:
       BssValFltRef(v) = realloc( BssValFltRef(v), sizeof(BssFltType));
FltInit(BssValFltRef(v));
      FltCopy( BssValFlt(v),BssValFlt( v1));
      break;
      
    case Interval:
       BssValItvRef(v) = realloc( BssValItvRef(v), sizeof(BssItvType));
ItvInit(BssValItvRef(v));
      ItvCopy( BssValItv(v),BssValItv( v1));
      break;
      /*      
	      case Union_of:
	       BssValUofRef(v) = realloc( BssValUofRef(v), sizeof(BssUofType));
UofInit(BssValUofRef(v));
	      UofCopy( BssValUof(v),BssValUof( v1));
	      break;
	      */      
    case Minus_infinity:
    case Plus_infinity:    
       BssValInfRef(v) = realloc( BssValInfRef(v), sizeof(BssInfType));
InfInit(BssValInfRef(v));
      InfCopy( BssValInf(v),BssValInf( v1));
      break;
    }
  else
    switch (BssGetType(v1)) {
    case Integer:
      BssValIntRef(v) = IntAlloc();/* malloc(sizeof(BssIntType)); */
      IntCopy( BssValInt(v), BssValInt( v1));
      break;
      
    case Rational:
      BssValRatRef(v) = RatAlloc();/* malloc(sizeof(BssRatType)); */
      RatCopy( BssValRat(v),BssValRat( v1));
      break;
      
    case Float:
      BssValFltRef(v) = FltAlloc(); /* malloc(sizeof(BssFltType)); */
      FltCopy( BssValFlt(v),BssValFlt( v1));
      break;
      
    case Interval:
      BssValItvRef(v) = ItvAlloc(); /* malloc(sizeof(BssItvType)); */
      ItvCopy( BssValItv(v),BssValItv( v1));
      break;
      /*      
	      case Union_of:
	      BssValUofRef(v) = UofAlloc(); 
	      UofCopy( BssValUof(v),BssValUof( v1));
	      break;
	      */      
    case Minus_infinity:
    case Plus_infinity:    
      BssValInfRef(v) = InfAlloc(); /* malloc(sizeof(BssInfType)); */
      InfCopy( BssValInf(v),BssValInf( v1));
      break;
    }
}
    

     
void BssFree( BssValueP v)
{
  BssFreeValue( v);
  free( v);
}

void BssAdd( BssValue v, const BssValue v1, const BssValue v2)
{
  BssValueP i, s;

  /*  BssFreeValue( v);*/
  if (BssIsInf( v1)) {
    if (InfIsMinus(BssValInf( v1)))
      BssSetType( v, Minus_infinity);
    else
      BssSetType( v, Plus_infinity);
    InfCopy( BssValInf( v), BssValInf( v1));
  }
  else if (BssIsInf( v2)) {
    if (InfIsMinus(BssValInf( v2)))
      BssSetType( v, Minus_infinity);
    else
      BssSetType( v, Plus_infinity);
    InfCopy( BssValInf( v), BssValInf( v2));
  }
  else
    BssApplyOp2( Add, v, v1, v2);
}

void BssSub( BssValue r, const BssValue r1, const BssValue r2)
{
  BssValueP i, s;
  /*  BssFreeValue( r);*/
  if (BssIsInf( r1)) {
    if (InfIsMinus(BssValInf( r1)))
      BssSetType( r, Minus_infinity);
    else
      BssSetType( r, Plus_infinity);
    InfCopy( BssValInf( r), BssValInf( r1));
  }
  else if (BssIsInf( r2)) {
    if (InfIsMinus(BssValInf( r2)))
      BssSetType( r, Plus_infinity);
    else
      BssSetType( r, Minus_infinity);
    InfMinus( BssValInf( r), BssValInf( r2));
  }
  else
    BssApplyOp2( Sub, r, r1, r2);
}

void BssMul( BssValue r, const BssValue r1, const BssValue r2)
{
  BssValueP i, s;
  /*  BssFreeValue( r);*/
  if (BssIsInf( r1)) {
    if (InfIsMinus(BssValInf( r1)))
      BssSetType( r, Minus_infinity);
    else
      BssSetType( r, Plus_infinity);
    InfCopy( BssValInf( r), BssValInf( r1));
  }
  else if (BssIsInf( r2)) {
    if (InfIsMinus(BssValInf( r2)))
      BssSetType( r, Minus_infinity);
    else
      BssSetType( r, Plus_infinity);
    InfCopy( BssValInf( r), BssValInf( r2));
  }
  else
    BssApplyOp2( Mul, r, r1, r2);
}
     
void BssDiv( BssValue r, const BssValue r1, const BssValue r2)
{
  BssValueP i, s;
  /*  BssFreeValue( r);*/
  if (BssIsInf( r1)) {
    if (InfIsMinus(BssValInf( r1)))
      BssSetType( r, Minus_infinity);
    else
      BssSetType( r, Plus_infinity);
    InfCopy( BssValInf( r), BssValInf( r1));
  }
  else if (BssIsInf( r2)) {
    BssSetType( r, Integer);
    IntSet( BssValInf( r), 0);
  }
  else
    BssApplyOp2( Div, r, r1, r2);
}
     
void BssPow( BssValue r, const BssValue r1, int n)
{
  /*  BssFreeValue( r); */
  if (BssIsInf( r1)) {
    if (InfIsMinus(BssValInf( r1))) {
      if (n%2) /* n is odd */
	BssSetType( r, Minus_infinity);
      else
	BssSetType( r, Plus_infinity);
      if (n%2) /* n is odd */
	BssValInf( r) = InfAllocCopy(  BssValInf( r1));
      else {
	BssValInf( r) = InfAlloc();
	InfMinus( BssValInf( r), BssValInf( r1));
      }
    }
    else {
      BssSetType( r, Plus_infinity);
      BssValInf( r) = InfAllocCopy(  BssValInf( r1));
    }
  }
  else
    {
      BssSetType( r, BssGetType( r1));
      switch (BssGetType(r1)) {
      case Integer:
	 	BssValIntRef( r) = realloc( 	BssValIntRef( r), sizeof( BssIntType));
IntInit(BssValIntRef( r));
	IntPow( BssValInt( r), BssValInt(r1), n);
	break;
      case Rational:
 	BssValRatRef( r) = realloc( 	BssValRatRef( r), sizeof( BssRatType));
RatInit(BssValRatRef( r));
	RatPow( BssValRat( r), BssValRat(r1), n);
	break;
      case Float:
 	BssValFltRef( r) = realloc( 	BssValFltRef( r), sizeof( BssFltType));
FltInit(BssValFltRef( r));
	FltPow( BssValFlt( r), BssValFlt(r1), n);
	break;
      
    case Interval:
       BssValItvRef( r) = realloc(       BssValItvRef( r), sizeof( BssItvType));
ItvInit(BssValItvRef( r));
      ItvPow( BssValItv( r), BssValItv(r1), n);
      break;
/*
    case Union_of:
       BssValUofRef( r) = realloc(       BssValUofRef( r), sizeof( BssUofType));
UofInit(BssValUofRef( r));
      UofPow( BssValUof( r), BssValUof(r1), n);
      break;
*/
      case Minus_infinity:
      case Plus_infinity:
 	BssValInfRef( r) = realloc( 	BssValInfRef( r), sizeof( BssInfType));
InfInit(BssValInfRef( r));
	InfPow( BssValInf( r), BssValInf(r1), n);
	break;
      }
    }
}

void BssMinus( BssValue r, const BssValue r1)
{
  /*  BssFreeValue( r); */
  if (BssIsInf( r1)) {
    if (InfIsMinus(BssValInf( r1)))
      BssSetType( r, Plus_infinity);
    else
      BssSetType( r, Minus_infinity);
    BssValInf(r) = InfAlloc();
    InfMinus( BssValInf( r), BssValInf( r1));
  }
  else
    BssApplyOp1( Minus, r, r1);
}

void BssSqrt( BssValue r, const BssValue r1)
{
  /*  BssFreeValue( r); */
  if (BssIsInf( r1)) {
    if (InfIsMinus(BssValInf( r1)))
      BssSetType( r, Minus_infinity);
    else
      BssSetType( r, Plus_infinity);
    BssValInf( r) = InfAllocCopy( BssValInf( r1));
  }
  else
    BssApplyOp1( Sqrt, r, r1);
}

void BssAbs( BssValue r, const BssValue r1)
{
  /*  BssFreeValue( r);*/
  if (BssIsInf( r1)) {
    BssSetType( r, Plus_infinity);
    BssValInf( r) = InfAllocInit( PlusInf);
  }
  else
    /*    BssApplyOp1( Abs, r, r1); */
    {
  BssSetType( r, BssGetType( r1));
  switch (BssGetType(r1)) {
    case Integer:
       BssValIntRef( r) = realloc(       BssValIntRef( r), sizeof( BssIntType));
IntInit(BssValIntRef( r));
      IntAbs( BssValInt( r), BssValInt(r1));
      break;
    case Rational:
       BssValRatRef( r) = realloc(       BssValRatRef( r), sizeof( BssRatType));
RatInit(BssValRatRef( r));
      RatAbs( BssValRat( r), BssValRat(r1));
      break;
    case Float:
       BssValFltRef( r) = realloc(       BssValFltRef( r), sizeof( BssFltType));
FltInit(BssValFltRef( r));
      FltAbs( BssValFlt( r), BssValFlt(r1));
      break;
    case Minus_infinity:
    case Plus_infinity:
       BssValInfRef( r) = realloc(       BssValInfRef( r), sizeof( BssInfType));
InfInit(BssValInfRef( r));
      InfAbs( BssValInf( r), BssValInf(r1));
      break;
    }
  }

}
     
void BssSqr( BssValue r, const BssValue r1)
{
  /*  BssFreeValue( r); */
  if (BssIsInf( r1)) {
    BssSetType( r, Plus_infinity);
    BssValInf( r) = InfAllocInit( PlusInf);
  }
  else
    BssApplyOp1( Sqr, r, r1);
}


int BssInter( BssValue  r, const BssValue v1, const BssValue v2)
{
  BssValueP s;
  BssValueP *fault; /* for Uof */
  int bot;
  
  /* if both have he same type, just call the right function */
  if (BssGetType( v1) == BssGetType( v2)) {
    BssSetType( r, BssGetType( v1));
    
    switch (BssGetType(v1)) {
    case Integer:
       BssValIntRef( r) = realloc(       BssValIntRef( r), sizeof( BssIntType));
IntInit(BssValIntRef( r));
      return IntInter( BssValInt(r), BssValInt(v1), BssValInt(v2));
      break;
      
    case Rational:
       BssValRatRef( r) = realloc(       BssValRatRef( r), sizeof( BssRatType));
RatInit(BssValRatRef( r));
      return RatInter( BssValRat(r), BssValRat(v1), BssValRat(v2));
      break;
      
    case Float:
       BssValFltRef( r) = realloc(       BssValFltRef( r), sizeof( BssFltType));
FltInit(BssValFltRef( r));
      return (int)FltInter( BssValFlt(r), BssValFlt(v1), BssValFlt(v2));
      break;
      
    case Interval:
       BssValItvRef( r) = realloc(       BssValItvRef( r), sizeof( BssItvType));
ItvInit(BssValItvRef( r));
      return ItvInter( BssValItv(r), BssValItv(v1), BssValItv(v2));
      break;
/*      
    case Union_of:
       BssValUofRef( r) = realloc(       BssValUofRef( r), sizeof( BssUofType));
UofInit(BssValUofRef( r));
      return UofInter( BssValUof(r), BssValUof(v1), BssValUof(v2));
      break;
*/      
    case Minus_infinity:
    case Plus_infinity:
       BssValInfRef( r) = realloc(       BssValInfRef( r), sizeof( BssInfType));
InfInit(BssValInfRef( r));
      return InfInter( BssValInf(r), BssValInf(v1), BssValInf(v2));
      break;
    }
  }
  /* if they have different types */
  
  /* if one of the types is +/- infinity and the other is basic */
  /* their intersection is empty                               */
  else if ((BssIsInf( v1) && BssIsBasic(v2))
	   || (BssIsInf( v2) && BssIsBasic(v1))) {
    return 0;
  }
  /* if one of the types is +/- infinity and the other is interval */
  /* convert the infinity to an interval                           */
  /* if one of the types is +/- infinity and the other is union_of */
  /* convert the infinity to an union_of                           */

  else if (BssIsInf( v1)) {
    if (BssIsItv( v2)) {
       BssValItvRef( r) = realloc(       BssValItvRef( r), sizeof( BssItvType));
ItvInit(BssValItvRef( r));
      return ItvInter(  BssValItv( r),
                        ItvAllocInit( v1, v1, 1, 1),
		        BssValItv(v2));
    }
/*
    else if (BssIsUof( v2)) {
     BssValUofRef( r) = realloc(     BssValUofRef( r), sizeof( BssUofType));
UofInit(BssValUofRef( r));
      return UofInter(  BssValUof( r),
                        UofAllocInit( v1, v1, 1, 1),
		        BssValUof(v2));
			}
			*/
  }

  else if (BssIsInf( v2)) {
    if (BssIsItv( v1)) {
       BssValItvRef( r) = realloc(       BssValItvRef( r), sizeof( BssItvType));
ItvInit(BssValItvRef( r));
      return ItvInter(  BssValItv( r),
			ItvAllocInit( v2, v2, 1, 1),
			BssValItv(v1));
			}
/*
    else if (BssIsUof( v1)){
         BssValUofRef( r) = realloc(         BssValUofRef( r), sizeof( BssUofType));
UofInit(BssValUofRef( r));
      return UofInter(  BssValUof( r),
                        UofAllocInit( v2, v2, 1, 1),
		        BssValUof(v1));
			}
			*/
  }

  /* else, convert both to the stronger type, and intersect */
  else {
    if (bot = BssOrderType( v1, v2) < 0) 
      s = v2;
    else 
      s = v1;

    BssSetType( r, BssGetType( s));
    switch(BssGetType(s)) {
      /* never an integer, because both can't be integers */
    case Rational:
      /* for the same reason, i must be an integer */
       BssValRatRef( r) = realloc(       BssValRatRef( r), sizeof( BssRatType));
RatInit(BssValRatRef( r));
      if (bot > 0) /* v1 is the weakest type */
	return RatInter( BssValRat( r),
			 RatAllocInit( IntVal(BssValInt( v1)), 1),
			 BssValRat(v2));
      else
	return RatInter( BssValRat( r),
			 BssValRat(v1),
			 RatAllocInit( IntVal(BssValInt( v2)), 1));
      break;
    case Float:
       BssValFltRef( r) = realloc(       BssValFltRef( r), sizeof( BssFltType));
FltInit(BssValFltRef( r));
      if (bot > 0) /* v1 is the weakest type */
	if (BssIsInt( v1))
	  return FltInter(  BssValFlt( r),
			    FltAllocInit( (double)(IntVal( BssValInt(v1)))),
			    BssValFlt(v2));
	else /* v1 is a rational */
	  return FltInter(  BssValFlt( r),
			    FltAllocInit( Rat2double( BssValRat( v1))),
			    BssValFlt(v2));
      else  /* v2 is the weakest type */
	if (BssIsInt( v2))
	  return FltInter(  BssValFlt( r),
			    BssValFlt(v1),
			    FltAllocInit( (double)(IntVal( BssValInt(v2)))));
	else /* v2 is a rational */
	  return FltInter(  BssValFlt( r),
			    BssValFlt(v1),
			    FltAllocInit( Rat2double( BssValRat( v2))));
			    break;

    case Interval:
       BssValItvRef( r) = realloc(       BssValItvRef( r), sizeof( BssItvType));
ItvInit(BssValItvRef( r));
      if (bot > 0) /* v1 is the weakest type */
	return ItvInter(  BssValItv( r),
			  ItvAllocInit( v1, v1, 1, 1),
			  BssValItv(v2));
      else
	return ItvInter(  BssValItv( r),
			  BssValItv(v1),
			  ItvAllocInit( v2, v2, 1, 1));

      break;
/*
    case Union_of:
         BssValUofRef( r) = realloc(         BssValUofRef( r), sizeof( BssUofType));
UofInit(BssValUofRef( r));
      if (bot > 0)
      return UofInter(  BssValUof( r),
                        UofAllocInit( fault, 1, v1),
		        BssValUof(v2));
else
        return UofInter(  BssValUof( r),
		        BssValUof(V&),
			  UofAllocInit( fault, 1, v2));
break;
*/    }
  }
}

void BssWrite( FILE *f, const BssValue v, int precision)
{
  switch (BssGetType( v)) {
  case Integer:
    IntWrite( f, BssValInt(v), precision);
    break;

  case Rational:
    RatWrite( f, BssValRat(v), precision);
    break;

  case Float:
    FltWrite( f, BssValFlt(v), FLT_PRECISION);
    break;

  case Interval:
    ItvWrite( f, BssValItv(v), precision);
    break;
/*
  case Union_of:
    UofWrite( f, BssVal(v), precision);
    break;
*/
  case Minus_infinity:
  case Plus_infinity:    
    InfWrite( f, BssValInf(v), precision);
    break;
  }
}

int BssCmp( const BssValue v1, const BssValue v2, int *cmp)
{
  BssValueP s;
  BssValueP *fault; /* for Uof */
  int bot;
  
  /* if both have he same type, just call the right function */
  if (BssGetType( v1) == BssGetType( v2)) {
    
    switch (BssGetType(v1)) {
    case Integer:
      return IntCmp( BssValInt(v1), BssValInt(v2), cmp);
      break;
      
    case Rational:
      return RatCmp( BssValRat(v1), BssValRat(v2), cmp);
      break;
      
    case Float:
      return (int)FltCmp( BssValFlt(v1), BssValFlt(v2), cmp);
      break;
      
    case Interval:
      return ItvCmp( BssValItv(v1), BssValItv(v2), cmp);
      break;
/*      
    case Union_of:
      return UofCmp( BssValUof(v1), BssValUof(v2), cmp);
      break;
*/      
    case Minus_infinity:
    case Plus_infinity:
      return InfCmp( BssValInf(v1), BssValInf(v2), cmp);
      break;
    }
  }
  /* if they have different types */
  /* if one of the types is an infinity, it is easy */
  else if (BssIsMinf( v1)) {
    *cmp =1;
    return -1;
  }
  else if (BssIsPinf( v1)) {
    *cmp =1;
    return 1;
  }
  else if (BssIsMinf( v2)) {
    *cmp =1;
    return 1;
  }
  else if (BssIsPinf( v2)) {
    *cmp =1;
    return -1;
  }
  /* else, convert both to the stronger type, and compare */
  else {
    if (bot = BssOrderType( v1, v2) < 0) 
      s = v2;
    else 
      s = v1;

    switch(BssGetType(s)) {
      /* never an integer, because both can't be integers */
    case Rational:
      /* for the same reason, i must be an integer */
      if (bot > 0) /* v1 is the weakest type */
	return RatCmp( 	 RatAllocInit( IntVal(BssValInt( v1)), 1),
			 BssValRat(v2), &cmp);
      else
	return RatCmp( BssValRat(v1),
		       RatAllocInit( IntVal(BssValInt( v2)), 1), &cmp);
      break;
    case Float:
      if (bot > 0) /* v1 is the weakest type */
	if (BssIsInt( v1))
	  return FltCmp( FltAllocInit( (double)(IntVal( BssValInt(v1)))),
			 BssValFlt(v2), &cmp);
	else /* v1 is a rational */
	  return FltCmp( FltAllocInit( Rat2double( BssValRat( v1))),
			 BssValFlt(v2), &cmp);
      else  /* v2 is the weakest type */
	if (BssIsInt( v2))
	  return FltCmp( BssValFlt(v1),
			 FltAllocInit( (double)(IntVal( BssValInt(v2)))), &cmp);
	else /* v2 is a rational */
	  return FltCmp( BssValFlt(v1),
			 FltAllocInit( Rat2double( BssValRat( v2))), &cmp);
			    break;

    case Interval:
      if (bot > 0) /* v1 is the weakest type */
	return ItvCmp( ItvAllocInit( v1, v1, 1, 1),
			BssValItv(v2), &cmp);
      else
	return ItvCmp( BssValItv(v1),
		       ItvAllocInit( v2, v2, 1, 1), &cmp);

      break;
/*
    case Union_of:
      if (bot > 0)
      return UofCmp( UofAllocInit( fault, 1, v1),
		     BssValUof(v2), &cmp);
else
        return UofCmp( BssValUof(V&),
		       UofAllocInit( fault, 1, v2), &cmp);
break;
*/    }
  }
}

char *Bss2bstring( const BssValue v, unsigned int *size)
{
  char *s, *sv;
  
  switch (BssGetType( v)) {
  case Integer:
    sv = Int2bstring( BssValInt(v), size);
    (*size)++;
    s = (char*)malloc( *size);
    s[0] = BssGetType( v);
    memcpy( &s[1], sv, INT_BSTRING_SIZE);
#ifdef LIBERE    
    free( sv);
#endif
    break;

  case Rational:
    sv = Rat2bstring( BssValRat(v), size);
    (*size)++;
    s = (char*)malloc( *size);
    s[0] = BssGetType( v);
    memcpy( &s[1], sv, *size);
#ifdef LIBERE    
    free( sv);
#endif
    break;

  case Float:
    sv = Flt2bstring( BssValFlt(v), size);
    (*size)++;
    s = (char*)malloc( *size);
    s[0] = BssGetType( v);
    memcpy( &s[1], sv, FLT_BSTRING_SIZE);
#ifdef LIBERE    
    free( sv);
#endif
    break;

  case Interval:
    sv = Itv2bstring( BssValItv(v), size);
    (*size)++;
    s = (char*)malloc( *size);
    s[0] = BssGetType( v);
    memcpy( &s[1], sv, *size-1);
#ifdef LIBERE    
    free( sv);
#endif
    break;
/*
  case Union_of:
    sv = Uof2bstring( BssValUof(v), size);
    (*size)++;
    s = (char*)malloc( *size);
    s[0] = BssGetType( v);
    memcpy( &s[1], sv, *size-1);
    break;
*/
  case Minus_infinity:
  case Plus_infinity:    
    sv = Inf2bstring( BssValInf(v), size);
    (*size)++;
    s = (char*)malloc( *size);
    s[0] = BssGetType( v);
    s[1] = *sv;
#ifdef LIBERE    
    free( sv);
#endif
    break;
  }

  return s;
}

BssValueP bstring2Bss( const char *s)
{
  BssValueP v;
  v = BssAlloc();

  BssSetType( v ,s[0]);
  switch (BssGetType( v)) {
  case Integer:
    BssValIntRef( v) = bstring2Int( &s[1]);
    break;

  case Rational:
    BssValRatRef( v) = bstring2Rat( &s[1]);
    break;

  case Float:
    BssValFltRef( v) = bstring2Flt( &s[1]);    
    break;

  case Interval:
    BssValItvRef( v) = bstring2Itv( &s[1]);
    break;
/*
  case Union_of:
    BssValUofRef( v) = bstring2Uof( &s[1]);
    break;
*/
  case Minus_infinity:
  case Plus_infinity:
        BssValInfRef( v) = bstring2Inf( &s[1]);
    break;
  }

  return v;
}

char *Bss2wstring( const BssValue v)
{
  switch (BssGetType( v)) {
  case Integer:
    return Int2wstring( BssValInt(v));
    break;

  case Rational:
    return Rat2wstring( BssValRat(v));
    break;

  case Float:
    return Flt2wstring( BssValFlt(v));
    break;

  case Interval:
    return Itv2wstring( BssValItv(v));
    break;
/*
  case Union_of:
    return Uof2wstring( BssValUof(v));
    break;
*/
  case Minus_infinity:
  case Plus_infinity:    
    return Inf2wstring( BssValInf(v));
    break;
  }
}

BssValueP wstring2Bss( const char *s)
{
  BssValueP v;

  v = BssAlloc();

  switch (s[0]) {
  case 'i':
    BssSetType( v, Integer);
    BssValIntRef( v) = wstring2Int( s);
    break;
    
  case 'q':
    BssSetType( v, Rational);
    BssValRatRef( v) = wstring2Rat( s);
    break;
    
  case 'f':
    BssSetType( v, Float);
    BssValFltRef( v) = wstring2Flt( s);
    break;

  case 'r':
    BssSetType( v, Interval);
    BssValItvRef( v) = wstring2Itv( s);
    break;
/*    
  case 'u':
    BssSetType( v, Union_of);
    BssValUofRef( v) = wstring2Uof( s);
    break;
*/    
  case 'l':
    BssValInfRef( v) = wstring2Inf( s);
    if (InfIsMinus(BssValInf( v)))
      BssSetType( v, Minus_infinity);
    else
      BssSetType( v, Plus_infinity);
    break;
  }
  return v;
}

