/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include "rational.h"
#include "integer.h"
#include <stdlib.h>
#include <gmp.h>

#define LIBERE

BssRatP RatAlloc()
{
  BssRatP r;
  r = (BssRatP)malloc( sizeof(BssRatType));
  RatInit( RatVal(r));
  return r;
}

BssRatP RatAllocCopy( const BssRat i)
{
  BssRatP r;
  r = RatAlloc();
  mpq_set(r, i);
  return r;
}

BssRatP RatAllocInit(signed long int n, unsigned long int d)
{
  BssRatP r;
  r = RatAlloc();
  mpq_set_si(r, n, d);
  if (d)
    mpq_canonicalize( r);
  return r;
}
     
/*-------------------------------------------------------------------------*/
/* RatPow                                                                  */
/*-------------------------------------------------------------------------*/
void RatPow( BssRat r, const BssRat x, int n)
{
  BssRat y;

  RatInit( y);
  RatInit( r);
  mpq_set( y, RatVal( x));
  RatSet( r, 1, 1);
  while (1) {
    if (IntMathIsOdd(n))
      mpq_mul(RatVal(r), RatVal(r), y);
    n>>=1;
    if (n==0) {
      mpq_canonicalize( RatVal(r));
      return;
    }
    mpq_mul( y, y, y);
  }
}

void RatWrite(FILE *out, const BssRat i, int digits)
{
  if (mpz_sgn( mpq_numref( RatVal(i))) > 0)
    fputc('+', out);
  mpz_out_str( out, 10, mpq_numref( RatVal(i)));
  fputc(':', out);
  mpz_out_str( out, 10, mpq_denref( RatVal(i)));
}

char* Rat2bstring( const BssRat v, unsigned int *size)
{
  char *s, *p, *r;
  long ln;
/* 
  ln = mpz_sizeinbase( mpq_numref( RatVal( v)), 10);

  *size = ln
        + mpz_sizeinbase( mpq_denref( RatVal( v)), 10)
        + 4;
  s = (char*)malloc( *size);

  if (mpz_sgn( mpq_numref( RatVal( v))) < 0)
  mpz_get_str( s, 10, mpq_numref( RatVal( v)));
  else {
    s[0]='+';
    mpz_get_str( &s[1], 10, mpq_numref( RatVal( v)));
  }  
  p = s + ln +1;
  *p=':';
  p++;
  mpz_get_str( p, 10, mpq_denref( RatVal( v))); */

  r = (char*)0;
  p = (char*)0;
  r = mpz_get_str( r, 10, mpq_numref( RatVal( v)));
  p = mpz_get_str( p, 10, mpq_denref( RatVal( v)));

  if (mpz_sgn( mpq_numref( RatVal( v))) < 0) {
    s = malloc( strlen(r)+strlen(p)+2); /* the minus sign is
					       already in s */
    sprintf( s, "%s:%s", r, p);
  }
  else {
    s = malloc( strlen(r)+strlen(p)+3); /* the plus sign is to add */
    sprintf( s, "+%s:%s", r, p);
  }

  free(r);
  free(p);

  *size = strlen( s) + 1;
  return s;
}

char *Rat2wstring( const BssRat v)
{
  int n;
  char *s, *s1;
  
  s1 = Rat2bstring( v, &n);
  s = (char*)malloc( n + 3);

  sprintf( s, "q(%s)", s1);
#ifdef LIBERE
  free(s1);
#endif  
  return s;
}

BssRatP bstring2Rat( const char *s)
{
  char *p;
  BssRatP r;
  mpz_t z;
  long den;

  for( p=s; *p!=':'; p++);
  p++;
  r = RatAlloc();
  den = atol( p);
  mpq_set_si( RatVal( r), (signed long int)atol(s), den);

  if (den)
    mpq_canonicalize( RatVal(r));
  return r;
}

BssRatP wstring2Rat( const char *s)
{
  if (s[0]=='q' && s[1]=='(') {
    return bstring2Rat( &s[2]);
  }
  else
    return 0;
}


