/***************************************************************************/
/* integer.h                                                               */
/*                                                                         */
/* Description file for operations on integers                             */
/*                                                                         */
/* Integer  Arithmetic Library                                             */
/*									   */
/***************************************************************************/

/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#ifndef INTEGER_H
#define INTEGER_H

#include <stdio.h>
#include <stdlib.h>

#define IntMathAbs(x) (((x)<=0) ? -(x) : x)

#define IntMathIsOdd(n) ((n)%2)
#define IntMathIsEven(n) (!((n)%2))

#define IntMathMin(x,y) (((x)<(y))? x : y)
#define IntMathMax(x,y) (((x)<(y))? y : x)

#define IntStrToInt(s)    atoi(s)
#define FltStrToDouble(s) atof(s)

#define IntVal( i) ((signed long int)((i)[0]))

#define INT_BSTRING_SIZE (sizeof( signed long))
/*-------------------------------------------------------------------------*/
/* BSS INTEGER                                                             */
/*-------------------------------------------------------------------------*/

typedef signed long int BssIntType;
typedef BssIntType BssInt[1];
typedef BssIntType *BssIntP;

#define  IntAlloc() \
     (BssIntP)malloc( sizeof(BssIntType))
BssIntP IntAllocCopy(const BssInt i);
BssIntP IntAllocInit(signed long int l);

#define IntInit(i)

#define  IntSet(i, n)\
     IntVal(i)=n
#define  IntCopy(i1, i2)\
     IntVal(i1)=IntVal(i2)
#define IntFree(i)\
     free(i)

#define IntAdd(i, i1, i2) \
     IntSet( i,  IntVal(i1)+IntVal(i2))
#define IntSub(i, i1, i2) \
     IntSet( i,  IntVal(i1)-IntVal(i2))
#define IntMinus(i, i1) \
     IntSet( i,  -IntVal(i1))
#define IntMul(i, i1, i2) \
     IntSet( i,  IntVal(i1)*(IntVal(i2)))
#define IntDiv(i, i1, i2) \
     IntSet( i,  IntVal(i1)/(IntVal(i2)))
#define IntSqrt(i, i1) \
     IntSet( i,  (signed long)sqrt((double)IntVal(i1)))
#define IntAbs(i, i1) \
     IntSet( i, IntMathAbs(IntVal(i1)))
#define IntSqr(i, i1) \
     IntSet( i,  IntVal(i1)*(IntVal(i1)))
void IntPow( BssInt i, const BssInt x, int n);

#define IntInter(i, i1, i2)\
     ((IntVal(i1)==IntVal(i2))\
     ? (IntSet( i,  IntVal(i1)), 1)\
     : 0)
     
#define IntWrite(out, i, digits)\
     fprintf(out,"%+.*ld", digits, IntVal(i))

char* Int2bstring( const BssInt v, unsigned int *size);

BssIntP bstring2Int( const char *s);
     
extern BssInt *klic2Int( void *);
extern void *Int2klic( const BssInt );

char *Int2wstring( const BssInt v);
BssIntP wstring2Int( const char *s);
     
#define IntCmp( i1, i2, pcmp)\
     (*pcmp=1, (IntVal(i1) - IntVal(i2)))
#endif   

