/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include "integer.h"
#include <stdlib.h>

#define digit2char( i) (i + (int)'0')

#undef LIBERE

BssIntP IntAllocCopy(const BssInt i)
{
  BssIntP r;
  r = (BssIntP)malloc( sizeof(BssIntType));
  IntVal(r) = IntVal(i);
  return r;
}

BssIntP IntAllocInit(signed long int l)
{
  BssIntP r;

  r = 0;
  r = (BssIntP)malloc( sizeof(BssIntType));
  IntVal(r) = l;
  return r;
}
     
/*-------------------------------------------------------------------------*/
/* IntPow                                                                  */
/*-------------------------------------------------------------------------*/
void IntPow( BssInt i, const BssInt x, int n)
{
  BssInt y;

  IntCopy( y, x);
  IntSet( i, 1);
  while (1) {
    if (IntMathIsOdd(n))
      IntVal(i) *= IntVal(y);
    n>>=1;
    if (n==0)
      return;
    IntVal(y) *= IntVal(y);
  }
}

char* Int2bstring( const BssInt v, unsigned int *size)
{
  char *s, *p;
  int j;
  
  s = (char*)malloc( INT_BSTRING_SIZE);
  p = (char *)&(IntVal( v));
  for (j = 0; j < INT_BSTRING_SIZE; j++, p++)
    s[j] = *p;
  
  *size = INT_BSTRING_SIZE;
  return s;

}

char *Int2wstring( const BssInt v)
{
  char *s1, *s2;
  int l,i;
  signed long n;
  
  n = IntVal(v);
  
  for (l=2 ;(n/=10)!=0 ;l++);
  s1 = (char*)malloc( l + 1);
  n = IntVal(v);
  if (n<0) {
    s1[0]='-';
    n = -n;
  }
  else
    s1[0]='+';
  s1[l]='\0';
  for (i=l-1; i>0; i--, n=n/10)
    s1[i] = digit2char(n%10);

  s2 = (char*)malloc( l+4);
  sprintf( s2, "i(%s)", s1);

#ifdef LIBERE  
  free(s1);
#endif  
  return s2;
}

BssIntP wstring2Int( const char *s)
{
  if (s[0]=='i' && s[1]=='(')
    return IntAllocInit( atol(&(s[2])));
  else
    return 0;
}

BssIntP bstring2Int( const char *s)
{
  signed long int i;
  int j;
  for (j=0; j<sizeof(signed long int); j++)
    ((char*)&i)[j] = s[j];
  return IntAllocInit( i);
}
