/***************************************************************************/
/* infinity.h                                                              */
/*                                                                         */
/* Description file for operations on minus infinity and plus infinity     */
/*                                                                         */
/***************************************************************************/

/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#ifndef INFINITY_H
#define INFINITY_H

/* typedef double BssInf; */
typedef char BssInfType;
typedef BssInfType BssInf[1];
typedef BssInfType *BssInfP;

/* static double Infinity =  1/0.0; */

/*
static double MinusInf = - 1/0.0;
static double PlusInf  = + 1/0.0;
*/
static char MinusInf = 0x1;
static char PlusInf  = 0x2;

#define InfIsMinus( i)\
     (InfVal(i)==MinusInf)

#define InfIsPlus( i)\
     (InfVal(i)==PlusInf)
     
#define InfVal( v) (((char*)(v))[0])

#define INF_BSTRING_SIZE (sizeof( char))
     
#define InfAlloc() \
     (BssInfP)malloc(sizeof(BssInfType))

BssInfP InfAllocCopy( const BssInf v1);
BssInfP InfAllocInit( char i);

#define InfInit(l)

#define InfSet( v, i)\
     InfVal( v) = (i)

#define InfCopy( v, v1)\
     InfVal(v) = InfVal(v1)

#define InfFree( v) free( v)

#define InfAdd(i, i1, i2) \
     InfSet( i,  InfVal(i1))
#define InfSub(i, i1, i2) \
     InfSet( i,  InfVal(i1))
#define InfMinus(i, i1) \
     InfSet( i,  (InfVal(i1)+1)%2 )
#define InfMul(i, i1, i2) \
     InfSet( i,  ( InfVal( i1)==InfVal(i2) ? PlusInf : MinusInf))
#define InfDiv(i, i1, i2) \
     InfSet( i,  InfVal(i1))
#define InfSqrt(i, i1) \
     InfSet( i,  InfVal(i1))
#define InfAbs(i, i1) \
     InfSet( i,  PlusInf)
#define InfSqr(i, i1) \
     InfSet( i,  PlusInf)
#define InfPow(i,  x, n) \
     InfSet( i, ( n%2==0)? PlusInf : InfVal(x))
       
#define InfInter( i, v1, v2) \
    (InfVal(v1) == InfVal(v2)\
     ? (InfSet( i,  InfVal(v1)), 1) \
     : 0)

#define InfWrite( out, v, precision)\
     fprintf(out,"%cInf",(InfVal(v) == MinusInf) ? '-':'+')
     
#define InfCmp( v1, v2, cmp) \
     (*cmp = 1, ( InfVal(v1) > InfVal(v2)\
		  ? 1\
		  : InfVal(v1) < InfVal(v2)\
		  ? -1\
		  :0))

char *Inf2bstring( const BssInf v, unsigned int *size);

#define bstring2Inf( s)\
     InfAllocInit( (s)[0]);

extern BssInf *klic2Inf( void *);
extern void *Inf2klic( const BssInf );

char *Inf2wstring( const BssInf v);
BssInfP wstring2Inf( char *s);

#endif
