/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include "float.h"
#include "integer.h"
#include <stdlib.h>

#undef LIBERE  

BssFltP FltAllocCopy(const BssFlt f)
{
  BssFltP r;
  r = (BssFltP)malloc( sizeof(BssFltType));
  FltRound;
  FltVal(r) = FltVal(f);
  return r;
}

BssFltP FltAllocInit(double d)
{
  BssFltP r;
  r = (BssFltP)malloc( sizeof(BssFltType));
  FltRound;
  FltVal(r) = d;
  return r;
}
     
/*-------------------------------------------------------------------------*/
/* FltPow                                                                  */
/*-------------------------------------------------------------------------*/
void FltPow( BssFlt r, const BssFlt x, int n)
{
  BssFlt y;

  FltCopy(y, x);
  FltSet( r, 1.0);
  while (1) {
    if (IntMathIsOdd(n)) {
      FltRound;
      FltVal(r) *=  FltVal(y);
    }
    n>>=1;
    if (n==0)
      return;
    FltRound;
    FltVal(y) *= FltVal(y);
  }
}

char* Flt2bstring( const BssFlt v, unsigned int *size)
{
  char *s, *p;
  int j;
  
  s = (char*)malloc( FLT_BSTRING_SIZE);
  FltRound;
  p = (char *)&(FltVal( v));
  for (j = 0; j < FLT_BSTRING_SIZE; j++, p++)
    s[j] = *p;

  *size = FLT_BSTRING_SIZE;
  return s;
}

char *Flt2wstring( const BssFlt v)
{
  char *s1, *s2;
  int l;
  
  double d;

  d = FltVal(v);

  s1 = (char*)malloc( FLT_BASE_STRING_SIZE + FLT_PRECISION);

  FltRound;
/* #ifdef _LINUX_
  sprintf( s1, "%.*g", FLT_PRECISION, d);
#else
  gconvert( d, FLT_PRECISION, 0, s1);
#endif */
  sprintf( s1, "%.*g", FLT_PRECISION, d);

  for (l=0 ; s1[l]!='\0' ;l++);
  s2 = (char*)malloc( l+5);

  if (d<0)
    sprintf( s2, "f(%s)",s1);
  else
    sprintf( s2, "f(+%s)", s1);

#ifdef LIBERE  
  free(s1);
#endif  
  return s2;
}

BssFltP wstring2Flt( const char *s)
{
  if (s[0]=='f' && s[1]=='(') {
    FltRound;
    return FltAllocInit( atof(&(s[2])));
  }
  else
    return 0;
}

int FltCmp( BssFlt f1, BssFlt f2, int *cmp)
{
 double d;
 
 *cmp = 1;
 FltRound;
 d = (FltVal(f1) - FltVal(f2));
 if (d < 0)
   return -1;
 else if (d > 0)
   return 1;
 else
   return 0;
}

BssFltP bstring2Flt( const char *s)
{
  double d;
  int j;
  FltRound;
  for (j=0; j<sizeof(double); j++)
    ((char*)&d)[j] = s[j];
  return FltAllocInit( d);

}
