/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#ifndef VARIABLE_H
#define VARIABLE_H

#include <stdio.h>

/*************************************************************/
/* Formula variable structure                                */

typedef int Location;

typedef struct {
  /* char **/ int Name;
  Location Loc;
} FVar;

#define FVarName( v) ((v)->Name)
#define FVarLoc( v)  ((v)->Loc)

FVar *FVarAllocInit( /* char **/ int name, Location loc);
void FVarFree( FVar *v);

void FVarWrite( FILE *f, FVar *v);

char *FVar2wstring( FVar *v);
FVar *wstring2FVar( const char *s);

char *FVar2bstring( FVar *v, int *length);
FVar *bstring2FVar( const char *s);

/* Returns the identifier of a variable in a string */
char *FVarExtractVars( FVar *v, int *l);

#endif
