/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#ifndef FORMULA_H
#define FORMULA_H

#include <value.h>
#include "fvar.h"

/*************************************************************/
/* BssFormula structure                                         */

typedef enum { _F_VAR = 1, _F_VAL = 2, _F_OP = 4} FmlType;

typedef struct {
  FmlType Type;    /* the two first bits denote the type of the node */
  void *Info;
} BssFormula;

#define FmlSetType( f, t)  ((f)->Type = t)
#define FmlGetType( f)  ((f)->Type)
#define FmlIsVar( f)    ((f)->Type == _F_VAR)
#define FmlIsVal( f)    ((f)->Type == _F_VAL)
#define FmlIsOp( f)    ((f)->Type == _F_OP)

#define FmlVariable( f) ((FVar*)((f)->Info))
#define FmlValue( f)    ((BssValue*)((f)->Info))
#define FmlOperator( f)    ((FOp*)((f)->Info))

#define FmlAlloc() (BssFormula*)malloc( sizeof( BssFormula));

BssFormula *FmlAllocInit( FmlType type, void *info);/* ...);*/

void FmlFree( BssFormula *f);

void FmlWrite( FILE *f, BssFormula *fl, int precision);

char *Fml2wstring( BssFormula *f);
BssFormula *wstring2Fml( char *s);

char *Fml2bstring( BssFormula *f, int *length);
BssFormula *bstring2Fml( char *s);

extern BssFormula *klic2Fml( void *);
extern void *Fml2klic( BssFormula *);

/* Extracts the identifiers of variables in f and concatenates them */
/* Identifiers can be repeated in the resulting string; l is its length */
char *FmlExtractVars( BssFormula *f, int *l);
#endif
