/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include <value.h>
#include "formula.h"
#include "fop.h"
#include "fvar.h"
#include <stdarg.h>
#include <stdlib.h>


int token( char *s, char c)
{
  int t;
  char *p;
  
  for (  t = 0, p = s; p && *p!=c; t++, p++)
    if (!p && *p!=c)
      t = -1;

  return t;
}

BssFormula *FmlAllocInit( FmlType type, void *info)/*...)*/
{
  BssFormula *f;
  va_list l;
  enum BssType typeval;
  
  f = (BssFormula *)malloc( sizeof(BssFormula));
  FmlSetType( f, type);

  f->Info = info;

  /* 
  va_start( l, type);

  if (FmlIsVar( f))
    f->Info = FVarAllocInit(va_arg( l, char *), va_arg( l, Location));
  
  else if (FmlIsOp( f)) {
    f->Info = (void*)FOpAllocInit( va_arg( l, char *),
				  va_arg( l, BssFormula *),
				  va_arg( l, BssFormula *) );
  }
  else
    f->Info = (void*)va_arg( l, BssValueP); */
    /*  {
    typeval = va_arg( l, enum BssType);
    switch (typeval) {
    case Integer:
      f->Info = (void*)BssAllocInit( typeval ,va_arg( l, signed long));
      break;
    case Rational:
      f->Info = (void*)BssAllocInit( typeval ,va_arg( l, signed long),
				     va_arg( l, unsigned long));
      break;
    case Float:
      f->Info = (void*)BssAllocInit( typeval ,va_arg( l, double));
      break;
    case Interval:
      f->Info = (void*)BssAllocInit( typeval ,va_arg( l, signed long));
      break;
    case Union_of:
      f->Info = (void*)BssAllocInit( typeval ,va_arg( l, signed long));
      break;
    case Minus_infinity:
      f->Info = (void*)BssAllocInit( typeval ,va_arg( l, char));
      break;
    case Plus_infinity:
      f->Info = (void*)BssAllocInit( typeval ,va_arg( l, char));
      break;
    }
  } */
/*   
  va_end( l); */

  return f;
}

void FmlFree( BssFormula *f)
{
  if (FmlIsVar( f))
    FVarFree( FmlVariable(f));
  else if (FmlIsVal( f))
    BssFree( f->Info);
  else if (FmlIsOp( f))
    FOpFree( f->Info);
  free( f);
}

void FmlWrite( FILE *f, BssFormula *fl, int precision)
{
  int i;
  Arg *a;
  if (FmlIsVar( fl))
    FVarWrite( f, FmlVariable( fl));
  
  else if (FmlIsVal( fl))
    BssWrite( f, FmlValue( fl), precision);
  
  else if (FmlIsOp( fl))
    FOpWrite( f, FmlOperator( fl), precision);
}

char *Fml2wstring( BssFormula *f)
{
  if (FmlIsVar( f))
    return FVar2wstring( FmlVariable( f));
  
  else if(FmlIsVal( f))
    return Bss2wstring( FmlValue( f));
  
  else if (FmlIsOp( f))
    return FOp2wstring( FmlOperator( f));
}

BssFormula *wstring2Fml( char *s)
{
  BssFormula *f;

  f = FmlAlloc();

  if (s[1] == '(')
    switch (s[0]) {
    case 'v':
      FmlSetType( f, _F_VAR);
      FmlVariable( f)= wstring2FVar( s);
      break;

    case 'b':
    case 'i':
    case 'q':
    case 'f':
    case 'r':
    case 'u':
      FmlSetType( f, _F_VAL);
      FmlValue( f)= wstring2Bss( s);
      break;

    default:
      FmlSetType( f, _F_OP);
      FmlOperator( f)= wstring2FOp( s);
    }
  else {
      FmlSetType( f, _F_OP);
      FmlOperator( f)= wstring2FOp( s);
  }

  return f;
}

char *Fml2bstring( BssFormula *f, int *length)
{
  char *s;

  s = Fml2wstring( f);
  *length = strlen( s) +1;
  return s;
}

BssFormula *bstring2Fml( char *s)
{
  return wstring2Fml( s);
}

char *FmlExtractVars( BssFormula *f, int *l)
{
  char *s = (char*)0;
  
  if (FmlIsVar( f)) 
    s = FVarExtractVars( FmlVariable(f), l);
 
  else if (FmlIsOp( f))
    s = FOpExtractVars( FmlOperator(f), l);

  else
    *l = 0;
    
  return s;
}
