/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

/*************************************************************/
/* Fop structure                                         */

#ifndef FOP_H
#define FOP_H

#include <stdarg.h>
#include "formula.h"

typedef struct {
  BssFormula *left, *right;
} Arg;

#define LeftArg( a) ((a)->left)
#define RightArg( a)  ((a)->right)

typedef struct {
  char *Name;
  Arg *Args;
} FOp;

#define FOpName( f)  ((f)->Name)
#define FOpArgs( f)  ((f)->Args)
/* by convention, unary operators have an empty right arg */
#define FOpIsBinary(f)(RightArg( FOpArgs( f)))

#define FOpAlloc() (FOp*)malloc( sizeof( FOp));

FOp *FOpAllocInit( char *name, BssFormula *left, BssFormula *right);
void FOpFree( FOp *f);

void FOpWrite( FILE *f, FOp *op, int precision);

char *FOp2wstring( FOp *f);
FOp *wstring2FOp( char *s);

char *FOp2bstring( FOp *f, int *length);
FOp *bstring2FOp( char *s);

/* Extracts the identifiers of variables in f and concatenates them */
/* Identifiers can be repeated in the resulting string; l is its length */
char *FOpExtractVars( FOp *f, int *l);

#endif



