/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include "local.h"

#define HASH_INIT 1011

struct entry {
  long int tag;
  void *info;
  struct entry *next;
};

/* Local variables */
struct entry *hvar[HASH_INIT];

/* Local constraints */
struct entry *hctr[HASH_INIT];

/* Temporary stuff */
struct entry *htmp[HASH_INIT];

void *insert(struct entry **t, long int s, void *v)
{
  unsigned int i;
  struct entry *p;

    i = s % HASH_INIT;   /* compute the hash code and get the entry */
    
  /* then add v at the beginning of the list */
  if (p = (struct entry*)malloc(sizeof(struct entry))) {
    p->tag  = s;
    p->info = v;
    p->next = t[i];
    t[i] = p;
      return (void*)p;
  }
  else
    return (void*)0;
}

void *find(struct entry **t, long int s)
{
  struct entry *p;
  unsigned int h = s % HASH_INIT;

  p = t[h]; /* compute the hash code and get the entry */

  while (p && (p->tag !=  s))
    p = p->next;

  if (p) {
    return p->info;
  }
  else
    return (void*)0;
}

void *myreplace(struct entry **t, long int s, void *v)
{
  unsigned int i;
  struct entry *p, *q;
  void *r;
  
    i =s % HASH_INIT;   /* compute the hash code and get the entry */
    
  /* then search if an entry named s exists */
  p = t[i]; /* get the entries list */

  if (!p) {
      p = (struct entry*)malloc(sizeof(struct entry));
      p->tag = s;
      p->info = v;
      p->next = (void*)0;
      t[i] = p;
      return (void*)0;
  }
  else if (p->tag == s) {
    /* the entry is at the beginning of the list */
    r = p->info;
    p->info = v;
    return r;
  }
  else {
    while (p->next && (p->next->tag != s))
      p = p->next;
        
    if (p->next) {/* the entry has been found */
      r = p->next->info;
      p->next->info = v;
      return r;
    }
    else {/* no existing entry; adds a new one */
      q = (struct entry*)malloc(sizeof(struct entry));
      q->tag = s;
      q->info = v;
      q->next = (void*)0;
      p->next = q;
      return (void*)0;
    }
  }
}

void myfree( struct entry **t, void (*efree)( void *))
{
  unsigned int i;
  struct entry *p, *q;
  
  for (i = 0; i < HASH_INIT; i++)
      if (t[i]) {
        p = t[i];
        while (p) {
	  q = p->next;
          efree( p->info);
	  free(p);
          p = q;
        }
      }
}


void *LocVarAdd( long int n, BssVar *v)
{
  return insert( hvar, n, v);
}

void *LocVarGetRep( long int name, char *rep)
{
  BssVar *v;
  v = find( hvar, name);
  if (v)
    return VarGetRep( v, rep);
  else {
      v = find( htmp, name);
      if (v)
	return VarGetRep( v, rep);
      else
	return (void*)0;
  }
}

BssVar *LocVarGetVar( long int name)
{
  BssVar *v;
  v = find( hvar, name);
  if (v)
    return v;
  else {
      v = find( htmp, name);
      return v;
  }
}

void *LocVarUpdateRep( long int name, char *rep, void *value)
{
  BssVar *v;

  v = LocVarGetVar( name);

  return VarUpdateRep( v, rep, value);
}

void *LocCtrAdd( long int n, BssCtr *c)
{
  return insert( hctr, n, c);
}
     
void *LocCtrGetRep( long int name, char *rep)
{
  BssCtr *c;
  c = find( hctr, name);
  if (c)
    return CtrGetRep( c, rep);
  else {
      c = find( htmp, name);
      if (c)
	return CtrGetRep( c, rep);
      else
	return (void*)0;
  }
}

BssCtr *LocCtrGetCtr( long int name)
{
  BssCtr *c;

  c = find( hctr, name);

  if (c)
    return c;
  else {
      c = find( htmp, name);
      return c;
  }
}

void *LocTmpAdd( long int n, char *v)
{
  return myreplace( htmp, n, v);
}

void Vlibere( void *v)
{
  VarFree( v, free);
}

void Clibere( void *v)
{
  CtrFree( v, free);
}

BssVar *LocVarFreeEntry( long int n)
{
  unsigned int i;
  struct entry *p, *q;
  BssVar *r;
  
  i = n % HASH_INIT;   /* compute the hash code and get the entry */

  p = hvar[i]; /* get the entries list */

  if (!p) 
    return (void*)0;
  
  else if (p->tag == n) {
    /* the entry is at the beginning of the list */
    r = p->info;
    q = p;
    p = p->next;
    free( q);
    return r;
  }
  else {
    while (p->next && (p->next->tag != n))
      p = p->next;
        
    if (p->next) {/* the entry has been found */
      r = p->next->info;
      q = p->next;
      p->next = p->next->next;
      free( q->next);
      return r;
    }
    else /* no existing entry */
      return (void*)0;
  }
}

BssCtr *LocCtrFreeEntry( long int n)
{
  unsigned int i;
  struct entry *p, *q;
  BssCtr *r;
  
  i = n % HASH_INIT;   /* compute the hash code and get the entry */

  p = hctr[i]; /* get the entries list */

  if (!p) 
    return (void*)0;
  
  else if (p->tag == n) {
    /* the entry is at the beginning of the list */
    r = p->info;
    q = p;
    p = p->next;
    free( q);
    return r;
  }
  else {
    while (p->next && (p->next->tag != n))
      p = p->next;
        
    if (p->next) {/* the entry has been found */
      r = p->next->info;
      q = p->next;
      p->next = p->next->next;
      free( q->next);
      return r;
    }
    else /* no existing entry */
      return (void*)0;
  }
}

void LocFreeAll()
{
  myfree( hvar, Vlibere);
  myfree( hctr, Clibere);
  myfree( htmp, free);
}

