/****************************************/
/****************************************/
/*
 * This file provides macros for creating and analysing
 * pointers in KLIC.  Pointers are larger than KLIC integers,
 * so the two are not interchangable.
 */
/****************************************/
/****************************************/

#ifndef POINTERS_H
#define POINTERS_H

#include <klic/gobj.h>
#include <klic/g_pointer.h>
#ifdef DIST
#include <klic/distio.h>
#endif

extern q gd_new_pointer();

/* Yield the C pointer stored in KLIC structure "k". */

#define ptrval(k) \
	((void*)((struct pointer_object *)(data_objectp(k)))->pointer)
 
/* Assign to "k" a KLIC structure containing C pointer "c". */

#define makeptr(k,c) {\
        k = gd_new_pointer ((q)(c), allocp); \
        allocp = heapp; \
        } 

#endif /* POINTERS_H */
